"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsAlert = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _contexts = require("../../../contexts");
var _selectors = require("../../../state/alert_rules/selectors");
var _alert_rules = require("../../../state/alert_rules");
var _synthetics_alerts = require("../../../../../../common/constants/synthetics_alerts");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSyntheticsAlert = isOpen => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const defaultRules = (0, _reactRedux.useSelector)(_selectors.selectSyntheticsAlerts);
  const loading = (0, _reactRedux.useSelector)(_selectors.selectSyntheticsAlertsLoading);
  const alertFlyoutVisible = (0, _reactRedux.useSelector)(_state.selectAlertFlyoutVisibility);
  const {
    canSave
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const getOrCreateAlerts = (0, _react.useCallback)(() => {
    if (canSave) {
      dispatch(_alert_rules.enableDefaultAlertingSilentlyAction.get());
    } else {
      dispatch(_alert_rules.getDefaultAlertingAction.get());
    }
  }, [canSave, dispatch]);
  (0, _react.useEffect)(() => {
    if (!defaultRules) {
      // on initial load we prioritize loading the app
      setTimeout(() => {
        getOrCreateAlerts();
      }, 1000);
    } else {
      getOrCreateAlerts();
    }
    // we don't want to run this on defaultRules change
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dispatch, isOpen]);
  const {
    triggersActionsUi
  } = (0, _public.useKibana)().services;
  const EditAlertFlyout = (0, _react.useMemo)(() => {
    if (!defaultRules) {
      return null;
    }
    return triggersActionsUi.getEditRuleFlyout({
      onClose: () => dispatch((0, _state.setAlertFlyoutVisible)(null)),
      hideInterval: true,
      initialRule: alertFlyoutVisible === _synthetics_alerts.SYNTHETICS_TLS_RULE ? defaultRules.tlsRule : defaultRules.statusRule
    });
  }, [defaultRules, dispatch, triggersActionsUi, alertFlyoutVisible]);
  return (0, _react.useMemo)(() => ({
    loading,
    EditAlertFlyout
  }), [EditAlertFlyout, loading]);
};
exports.useSyntheticsAlert = useSyntheticsAlert;