"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSentinelOneConnectorType = void 0;
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _constants = require("../../../common/sentinelone/constants");
var _schema = require("../../../common/sentinelone/schema");
var _sentinelone = require("./sentinelone");
var _render = require("./render");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSentinelOneConnectorType = () => ({
  id: _constants.SENTINELONE_CONNECTOR_ID,
  name: _constants.SENTINELONE_TITLE,
  getService: params => new _sentinelone.SentinelOneConnector(params),
  schema: {
    config: _schema.SentinelOneConfigSchema,
    secrets: _schema.SentinelOneSecretsSchema
  },
  validators: [{
    type: _types.ValidatorType.CONFIG,
    validator: (0, _server.urlAllowListValidator)('url')
  }],
  supportedFeatureIds: [_common.SecurityConnectorFeatureId],
  minimumLicenseRequired: 'enterprise',
  renderParameterTemplates: _render.renderParameterTemplates
});
exports.getSentinelOneConnectorType = getSentinelOneConnectorType;