"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _string = require("@kbn/es-ui-shared-plugin/static/validators/string");
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  urlField,
  emptyField
} = _helpers.fieldValidators;
const Callout = ({
  title,
  dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    iconType: "iInCircle",
    "data-test-subj": dataTestSubj,
    title: title
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const torqWebhookEndpoint = message => (...args) => {
  const [{
    value
  }] = args;
  const error = {
    code: 'ERR_FIELD_FORMAT',
    formatType: 'URL',
    message
  };
  if (!(0, _string.isUrl)(value)) return error;
  const hostname = new URL(value).hostname;
  return hostname === 'hooks.torq.io' ? undefined : error;
};
const TorqActionConnectorFields = ({
  readOnly
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(Callout, {
    title: i18n.HOW_TO_TEXT,
    dataTestSubj: "torq-how-to"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.webhookIntegrationUrl",
    config: {
      label: i18n.URL_LABEL,
      validations: [{
        validator: urlField(i18n.URL_INVALID)
      }, {
        validator: torqWebhookEndpoint(i18n.URL_NOT_TORQ_WEBHOOK)
      }]
    },
    helpText: i18n.URL_HELP_TEXT,
    component: _components.Field,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'torqUrlText',
        fullWidth: true
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.token",
    config: {
      label: i18n.TORQ_TOKEN_LABEL,
      validations: [{
        validator: emptyField(i18n.TORQ_TOKEN_REQUIRED)
      }],
      helpText: i18n.TORQ_TOKEN_HELP_TEXT
    },
    component: _components.PasswordField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'torqTokenInput',
        readOnly
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = TorqActionConnectorFields;
module.exports = exports.default;