"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEBHOOK_URL_PLACEHOLDER = exports.WEBHOOK_URL_LABEL = exports.WEBHOOK_URL_HELP = exports.WEBHOOK_URL_FALLBACK_TITLE = exports.WEBHOOK_URL_FALLBACK_TEXT = exports.WEBHOOK_SECRET_REQUIRED = exports.WEBHOOK_REQUIRED = exports.WEBHOOK_PLACEHOLDER = exports.WEBHOOK_PATH_REQUIRED = exports.WEBHOOK_NOT_FOUND_WARNING = exports.WEBHOOK_LABEL = exports.WEBHOOK_HELP = exports.WEBHOOK_DISABLED_PLACEHOLDER = exports.WEBHOOK_ARIA_LABEL = exports.WEBHOOKS_ERROR = exports.URL_LABEL = exports.URL_INVALID = exports.TOKEN_REQUIRED = exports.TOKEN_LABEL = exports.STORY_REQUIRED = exports.STORY_PUBLISHED_BADGE_TEXT = exports.STORY_PLACEHOLDER = exports.STORY_NOT_FOUND_WARNING = exports.STORY_LABEL = exports.STORY_HELP = exports.STORY_ARIA_LABEL = exports.STORIES_ERROR = exports.INVALID_WEBHOOK_URL = exports.INVALID_PROTOCOL_WEBHOOK_URL = exports.INVALID_HOSTNAME_WEBHOOK_URL = exports.INVALID_ACTION = exports.EMAIL_REQUIRED = exports.EMAIL_LABEL = exports.DISABLED_BY_WEBHOOK_URL_PLACEHOLDER = exports.BODY_REQUIRED = exports.BODY_LABEL = exports.BODY_INVALID = exports.BODY_ARIA_LABEL = exports.AUTHENTICATION_TITLE = exports.ACTION_REQUIRED = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/tines/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// config form
const URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.urlTextFieldLabel', {
  defaultMessage: 'Tines tenant URL'
});
exports.URL_LABEL = URL_LABEL;
const AUTHENTICATION_TITLE = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.authenticationTitle', {
  defaultMessage: 'Authentication'
});
exports.AUTHENTICATION_TITLE = AUTHENTICATION_TITLE;
const EMAIL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.emailTextFieldLabel', {
  defaultMessage: 'Email'
});
exports.EMAIL_LABEL = EMAIL_LABEL;
const TOKEN_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.tokenTextFieldLabel', {
  defaultMessage: 'API token'
});
exports.TOKEN_LABEL = TOKEN_LABEL;
const URL_INVALID = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.error.invalidUrlTextField', {
  defaultMessage: 'Tenant URL is invalid.'
});
exports.URL_INVALID = URL_INVALID;
const EMAIL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.error.requiredEmailText', {
  defaultMessage: 'Email is required.'
});
exports.EMAIL_REQUIRED = EMAIL_REQUIRED;
const TOKEN_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.error.requiredAuthTokenText', {
  defaultMessage: 'Auth token is required.'
});

// params form
exports.TOKEN_REQUIRED = TOKEN_REQUIRED;
const STORY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.storyFieldLabel', {
  defaultMessage: 'Tines Story'
});
exports.STORY_LABEL = STORY_LABEL;
const STORY_HELP = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.storyHelp', {
  defaultMessage: 'The Tines story to send the events to'
});
exports.STORY_HELP = STORY_HELP;
const STORY_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.storyPlaceholder', {
  defaultMessage: 'Select a story'
});
exports.STORY_PLACEHOLDER = STORY_PLACEHOLDER;
const STORY_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.storyFieldAriaLabel', {
  defaultMessage: 'Select a Tines story'
});
exports.STORY_ARIA_LABEL = STORY_ARIA_LABEL;
const STORY_PUBLISHED_BADGE_TEXT = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.storyPublishedBadgeText', {
  defaultMessage: 'Published'
});
exports.STORY_PUBLISHED_BADGE_TEXT = STORY_PUBLISHED_BADGE_TEXT;
const WEBHOOK_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookFieldLabel', {
  defaultMessage: 'Tines Webhook action'
});
exports.WEBHOOK_LABEL = WEBHOOK_LABEL;
const WEBHOOK_HELP = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookHelp', {
  defaultMessage: 'The data entry action in the story'
});
exports.WEBHOOK_HELP = WEBHOOK_HELP;
const WEBHOOK_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookPlaceholder', {
  defaultMessage: 'Select a webhook action'
});
exports.WEBHOOK_PLACEHOLDER = WEBHOOK_PLACEHOLDER;
const WEBHOOK_DISABLED_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookDisabledPlaceholder', {
  defaultMessage: 'Select a story first'
});
exports.WEBHOOK_DISABLED_PLACEHOLDER = WEBHOOK_DISABLED_PLACEHOLDER;
const WEBHOOK_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookFieldAriaLabel', {
  defaultMessage: 'Select a Tines webhook action'
});
exports.WEBHOOK_ARIA_LABEL = WEBHOOK_ARIA_LABEL;
const WEBHOOK_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookUrlFieldLabel', {
  defaultMessage: 'Webhook URL'
});
exports.WEBHOOK_URL_LABEL = WEBHOOK_URL_LABEL;
const WEBHOOK_URL_FALLBACK_TITLE = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookUrlFallbackTitle', {
  defaultMessage: 'Tines API results limit reached'
});
exports.WEBHOOK_URL_FALLBACK_TITLE = WEBHOOK_URL_FALLBACK_TITLE;
const WEBHOOK_URL_FALLBACK_TEXT = entity => _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookUrlFallbackText', {
  values: {
    entity,
    limit: _constants.API_MAX_RESULTS
  },
  defaultMessage: `Not possible to retrieve more than {limit} results from the Tines {entity} API. If your {entity} does not appear in the list, please fill the Webhook URL below`
});
exports.WEBHOOK_URL_FALLBACK_TEXT = WEBHOOK_URL_FALLBACK_TEXT;
const WEBHOOK_URL_HELP = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookUrlHelp', {
  defaultMessage: 'The Story and Webhook selectors will be ignored if the Webhook URL is defined'
});
exports.WEBHOOK_URL_HELP = WEBHOOK_URL_HELP;
const WEBHOOK_URL_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookUrlPlaceholder', {
  defaultMessage: 'Paste the Webhook URL here'
});
exports.WEBHOOK_URL_PLACEHOLDER = WEBHOOK_URL_PLACEHOLDER;
const DISABLED_BY_WEBHOOK_URL_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.disabledByWebhookUrlPlaceholder', {
  defaultMessage: 'Remove the Webhook URL to use this selector'
});
exports.DISABLED_BY_WEBHOOK_URL_PLACEHOLDER = DISABLED_BY_WEBHOOK_URL_PLACEHOLDER;
const BODY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.bodyFieldLabel', {
  defaultMessage: 'Body'
});
exports.BODY_LABEL = BODY_LABEL;
const BODY_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.bodyFieldAriaLabel', {
  defaultMessage: 'Request body payload'
});
exports.BODY_ARIA_LABEL = BODY_ARIA_LABEL;
const STORIES_ERROR = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.componentError.storiesRequestFailed', {
  defaultMessage: 'Error retrieving stories from Tines'
});
exports.STORIES_ERROR = STORIES_ERROR;
const WEBHOOKS_ERROR = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.componentError.webhooksRequestFailed', {
  defaultMessage: 'Error retrieving webhook actions from Tines'
});
exports.WEBHOOKS_ERROR = WEBHOOKS_ERROR;
const STORY_NOT_FOUND_WARNING = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.componentWarning.storyNotFound', {
  defaultMessage: 'Cannot find the saved story. Please select a valid story from the selector'
});
exports.STORY_NOT_FOUND_WARNING = STORY_NOT_FOUND_WARNING;
const WEBHOOK_NOT_FOUND_WARNING = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.componentWarning.webhookNotFound', {
  defaultMessage: 'Cannot find the saved webhook. Please select a valid webhook from the selector'
});
exports.WEBHOOK_NOT_FOUND_WARNING = WEBHOOK_NOT_FOUND_WARNING;
const ACTION_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.requiredActionText', {
  defaultMessage: 'Action is required.'
});
exports.ACTION_REQUIRED = ACTION_REQUIRED;
const INVALID_ACTION = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.invalidActionText', {
  defaultMessage: 'Invalid action name.'
});
exports.INVALID_ACTION = INVALID_ACTION;
const BODY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.requiredBodyText', {
  defaultMessage: 'Body is required.'
});
exports.BODY_REQUIRED = BODY_REQUIRED;
const BODY_INVALID = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.invalidBodyText', {
  defaultMessage: 'Body does not have a valid JSON format.'
});
exports.BODY_INVALID = BODY_INVALID;
const STORY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.requiredStoryText', {
  defaultMessage: 'Story is required.'
});
exports.STORY_REQUIRED = STORY_REQUIRED;
const WEBHOOK_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.requiredWebhookText', {
  defaultMessage: 'Webhook is required.'
});
exports.WEBHOOK_REQUIRED = WEBHOOK_REQUIRED;
const WEBHOOK_PATH_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.requiredWebhookPathText', {
  defaultMessage: 'Webhook action path is missing.'
});
exports.WEBHOOK_PATH_REQUIRED = WEBHOOK_PATH_REQUIRED;
const WEBHOOK_SECRET_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.requiredWebhookSecretText', {
  defaultMessage: 'Webhook action secret is missing.'
});
exports.WEBHOOK_SECRET_REQUIRED = WEBHOOK_SECRET_REQUIRED;
const INVALID_WEBHOOK_URL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.invalidWebhookUrlText', {
  defaultMessage: 'Webhook URL is invalid.'
});
exports.INVALID_WEBHOOK_URL = INVALID_WEBHOOK_URL;
const INVALID_HOSTNAME_WEBHOOK_URL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.invalidHostnameWebhookUrlText', {
  defaultMessage: 'Webhook URL does not have a valid ".tines.com" domain.'
});
exports.INVALID_HOSTNAME_WEBHOOK_URL = INVALID_HOSTNAME_WEBHOOK_URL;
const INVALID_PROTOCOL_WEBHOOK_URL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.invalidProtocolWebhookUrlText', {
  defaultMessage: 'Webhook URL does not have a valid "https" protocol.'
});
exports.INVALID_PROTOCOL_WEBHOOK_URL = INVALID_PROTOCOL_WEBHOOK_URL;