"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _use_get_incident_types = require("./use_get_incident_types");
var _use_get_severity = require("./use_get_severity");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResilientParamsFields = ({
  actionConnector,
  actionParams,
  editAction,
  errors,
  index,
  messageVariables
}) => {
  var _actionConnector$id, _incident$severityCod, _incident$name, _errors$subActionPara, _incident$description;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const actionConnectorRef = (0, _react.useRef)((_actionConnector$id = actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id) !== null && _actionConnector$id !== void 0 ? _actionConnector$id : '');
  const {
    incident,
    comments
  } = (0, _react.useMemo)(() => {
    var _actionParams$subActi;
    return (_actionParams$subActi = actionParams.subActionParams) !== null && _actionParams$subActi !== void 0 ? _actionParams$subActi : {
      incident: {},
      comments: []
    };
  }, [actionParams.subActionParams]);
  const {
    isLoading: isLoadingIncidentTypes,
    incidentTypes: allIncidentTypes
  } = (0, _use_get_incident_types.useGetIncidentTypes)({
    http,
    toastNotifications: toasts,
    actionConnector
  });
  const {
    isLoading: isLoadingSeverity,
    severity
  } = (0, _use_get_severity.useGetSeverity)({
    http,
    toastNotifications: toasts,
    actionConnector
  });
  const severitySelectOptions = (0, _react.useMemo)(() => {
    return severity.map(s => ({
      value: s.id.toString(),
      text: s.name
    }));
  }, [severity]);
  const incidentTypesComboBoxOptions = (0, _react.useMemo)(() => allIncidentTypes ? allIncidentTypes.map(type => ({
    label: type.name,
    value: type.id.toString()
  })) : [], [allIncidentTypes]);
  const selectedIncidentTypesComboBoxOptions = (0, _react.useMemo)(() => {
    const allIncidentTypesAsObject = allIncidentTypes.reduce((acc, type) => ({
      ...acc,
      [type.id.toString()]: type.name
    }), {});
    return incident.incidentTypes ? incident.incidentTypes.map(type => ({
      label: allIncidentTypesAsObject[type.toString()],
      value: type.toString()
    })).filter(type => type.label != null) : [];
  }, [allIncidentTypes, incident.incidentTypes]);
  const editSubActionProperty = (0, _react.useCallback)((key, value) => {
    const newProps = key !== 'comments' ? {
      incident: {
        ...incident,
        [key]: value
      },
      comments
    } : {
      incident,
      [key]: value
    };
    editAction('subActionParams', newProps, index);
  }, [comments, editAction, incident, index]);
  const editComment = (0, _react.useCallback)((key, value) => {
    editSubActionProperty(key, [{
      commentId: '1',
      comment: value
    }]);
  }, [editSubActionProperty]);
  const incidentTypesOnChange = (0, _react.useCallback)(selectedOptions => {
    editSubActionProperty('incidentTypes', selectedOptions.map(selectedOption => {
      var _selectedOption$value;
      return (_selectedOption$value = selectedOption.value) !== null && _selectedOption$value !== void 0 ? _selectedOption$value : selectedOption.label;
    }));
  }, [editSubActionProperty]);
  const incidentTypesOnBlur = (0, _react.useCallback)(() => {
    if (!incident.incidentTypes) {
      editSubActionProperty('incidentTypes', []);
    }
  }, [editSubActionProperty, incident.incidentTypes]);
  (0, _react.useEffect)(() => {
    if (actionConnector != null && actionConnectorRef.current !== actionConnector.id) {
      actionConnectorRef.current = actionConnector.id;
      editAction('subActionParams', {
        incident: {},
        comments: []
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionConnector]);
  (0, _react.useEffect)(() => {
    if (!actionParams.subAction) {
      editAction('subAction', 'pushToService', index);
    }
    if (!actionParams.subActionParams) {
      editAction('subActionParams', {
        incident: {},
        comments: []
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "Incident")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.resilient.urgencySelectFieldLabel', {
      defaultMessage: 'Incident Type'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    isLoading: isLoadingIncidentTypes,
    isDisabled: isLoadingIncidentTypes,
    "data-test-subj": "incidentTypeComboBox",
    options: incidentTypesComboBoxOptions,
    selectedOptions: selectedIncidentTypesComboBoxOptions,
    onChange: incidentTypesOnChange,
    onBlur: incidentTypesOnBlur,
    isClearable: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.resilient.severity', {
      defaultMessage: 'Severity'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "severitySelect",
    disabled: isLoadingSeverity,
    fullWidth: true,
    hasNoInitialSelection: true,
    isLoading: isLoadingSeverity,
    onChange: e => editSubActionProperty('severityCode', e.target.value),
    options: severitySelectOptions,
    value: (_incident$severityCod = incident.severityCode) !== null && _incident$severityCod !== void 0 ? _incident$severityCod : undefined
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors['subActionParams.incident.name'],
    isInvalid: errors['subActionParams.incident.name'] !== undefined && errors['subActionParams.incident.name'].length > 0 && incident.name !== undefined,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.resilient.nameFieldLabel', {
      defaultMessage: 'Name (required)'
    })
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'name',
    inputTargetValue: (_incident$name = incident.name) !== null && _incident$name !== void 0 ? _incident$name : undefined,
    errors: (_errors$subActionPara = errors['subActionParams.incident.name']) !== null && _errors$subActionPara !== void 0 ? _errors$subActionPara : []
  })), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'description',
    inputTargetValue: (_incident$description = incident.description) !== null && _incident$description !== void 0 ? _incident$description : undefined,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.resilient.descriptionTextAreaFieldLabel', {
      defaultMessage: 'Description'
    })
  }), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editComment,
    messageVariables: messageVariables,
    paramsProperty: 'comments',
    inputTargetValue: comments && comments.length > 0 ? comments[0].comment : undefined,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.resilient.commentsTextAreaFieldLabel', {
      defaultMessage: 'Additional comments'
    })
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = ResilientParamsFields;
module.exports = exports.default;