"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecatedCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeprecatedCalloutComponent = ({
  onMigrate
}) => {
  const update = onMigrate != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onMigrate,
    "data-test-subj": "update-connector-btn"
  }, updateThisConnectorMessage) : /*#__PURE__*/_react.default.createElement("span", null, updateThisConnectorMessage);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    iconType: "warning",
    "data-test-subj": "snDeprecatedCallout",
    color: "warning",
    title: _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.deprecatedCalloutTitle', {
      defaultMessage: 'This connector type is deprecated'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{update} {create} ",
    id: "xpack.stackConnectors.components.serviceNow.appInstallationInfo",
    values: {
      update,
      create: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.deprecatedCalloutCreate', {
        defaultMessage: 'or create a new one.'
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const DeprecatedCallout = /*#__PURE__*/(0, _react.memo)(DeprecatedCalloutComponent);
exports.DeprecatedCallout = DeprecatedCallout;
const updateThisConnectorMessage = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.deprecatedCalloutMigrate', {
  defaultMessage: 'Update this connector,'
});