"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _constants = require("../../../common/d3security/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const D3ParamsFields = ({
  actionParams,
  editAction,
  index,
  messageVariables,
  executionMode,
  errors
}) => {
  const {
    subAction,
    subActionParams
  } = actionParams;
  const {
    body,
    severity,
    eventType
  } = subActionParams !== null && subActionParams !== void 0 ? subActionParams : {};
  const isTest = (0, _react.useMemo)(() => executionMode === _public.ActionConnectorMode.Test, [executionMode]);
  (0, _react.useEffect)(() => {
    if (!subAction) {
      editAction('subAction', isTest ? _constants.SUB_ACTION.TEST : _constants.SUB_ACTION.RUN, index);
    }
  }, [editAction, index, isTest, subAction]);
  const editSubActionParams = (0, _react.useCallback)(params => {
    editAction('subActionParams', {
      ...subActionParams,
      ...params
    }, index);
  }, [editAction, index, subActionParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.eventType,
    isInvalid: false,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.d3security.eventTypeFieldLabel', {
      defaultMessage: 'Event Type'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "eventTypeInput",
    name: "eventType",
    value: eventType,
    onChange: e => {
      editSubActionParams({
        eventType: e.target.value
      });
    },
    isInvalid: false,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.severity,
    isInvalid: false,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.d3security.severityFieldLabel', {
      defaultMessage: 'Severity'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "severityInput",
    name: "severity",
    value: severity,
    onChange: e => {
      editSubActionParams({
        severity: e.target.value
      });
    },
    isInvalid: false,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'body',
    inputTargetValue: body,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.d3security.bodyFieldLabel', {
      defaultMessage: 'Body'
    }),
    "aria-label": _i18n.i18n.translate('xpack.stackConnectors.components.d3security.bodyCodeEditorAriaLabel', {
      defaultMessage: 'Code editor'
    }),
    errors: errors.body,
    onDocumentsChange: json => {
      editSubActionParams({
        body: json
      });
    },
    onBlur: () => {
      if (!body) {
        editSubActionParams({
          body: ''
        });
      }
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = D3ParamsFields;
module.exports = exports.default;