"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUrlButCanBeEmpty = exports.containsTitleAndDesc = exports.containsExternalIdOrTitle = exports.containsExternalId = exports.containsCommentsOrEmpty = void 0;
var _string = require("@kbn/es-ui-shared-plugin/static/validators/string");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _action_variables = require("./action_variables");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorCode = 'ERR_FIELD_MISSING';
const missingVariableErrorMessage = (path, variables) => ({
  code: errorCode,
  path,
  message: i18n.MISSING_VARIABLES(variables)
});
const containsTitleAndDesc = () => (...args) => {
  const [{
    value,
    path
  }] = args;
  const title = (0, _public.templateActionVariable)(_action_variables.casesVars.find(actionVariable => actionVariable.name === 'case.title'));
  const description = (0, _public.templateActionVariable)(_action_variables.casesVars.find(actionVariable => actionVariable.name === 'case.description'));
  const varsWithErrors = [title, description].filter(variable => !(0, _string.containsChars)(variable)(value).doesContain);
  if (varsWithErrors.length > 0) {
    return missingVariableErrorMessage(path, varsWithErrors);
  }
};
exports.containsTitleAndDesc = containsTitleAndDesc;
const containsExternalId = () => (...args) => {
  const [{
    value,
    path
  }] = args;
  const id = (0, _public.templateActionVariable)(_action_variables.urlVars.find(actionVariable => actionVariable.name === 'external.system.id'));
  return (0, _string.containsChars)(id)(value).doesContain ? undefined : missingVariableErrorMessage(path, [id]);
};
exports.containsExternalId = containsExternalId;
const containsExternalIdOrTitle = () => (...args) => {
  const [{
    value,
    path
  }] = args;
  const id = (0, _public.templateActionVariable)(_action_variables.urlVars.find(actionVariable => actionVariable.name === 'external.system.id'));
  const title = (0, _public.templateActionVariable)(_action_variables.urlVarsExt.find(actionVariable => actionVariable.name === 'external.system.title'));
  const error = missingVariableErrorMessage(path, [id, title]);
  if (typeof value === 'string') {
    const {
      doesContain: doesContainId
    } = (0, _string.containsChars)(id)(value);
    const {
      doesContain: doesContainTitle
    } = (0, _string.containsChars)(title)(value);
    if (doesContainId || doesContainTitle) {
      return undefined;
    }
  }
  return error;
};
exports.containsExternalIdOrTitle = containsExternalIdOrTitle;
const containsCommentsOrEmpty = message => (...args) => {
  const [{
    value,
    path
  }] = args;
  if (typeof value !== 'string') {
    return {
      code: 'ERR_FIELD_FORMAT',
      formatType: 'STRING',
      message
    };
  }
  if (value.length === 0) {
    return undefined;
  }
  const comment = (0, _public.templateActionVariable)(_action_variables.commentVars.find(actionVariable => actionVariable.name === 'case.comment'));
  let error;
  if (typeof value === 'string') {
    const {
      doesContain
    } = (0, _string.containsChars)(comment)(value);
    if (!doesContain) {
      error = missingVariableErrorMessage(path, [comment]);
    }
  }
  return error;
};
exports.containsCommentsOrEmpty = containsCommentsOrEmpty;
const isUrlButCanBeEmpty = message => (...args) => {
  const [{
    value
  }] = args;
  const error = {
    code: 'ERR_FIELD_FORMAT',
    formatType: 'URL',
    message
  };
  if (typeof value !== 'string') {
    return error;
  }
  if (value.length === 0) {
    return undefined;
  }
  return (0, _string.isUrl)(value) ? undefined : error;
};
exports.isUrlButCanBeEmpty = isUrlButCanBeEmpty;