"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALUE_LABEL = exports.USERNAME_REQUIRED = exports.USERNAME = exports.UPDATE_URL_REQUIRED = exports.UPDATE_METHOD_REQUIRED = exports.UPDATE_INCIDENT_URL_HELP = exports.UPDATE_INCIDENT_URL = exports.UPDATE_INCIDENT_REQUIRED = exports.UPDATE_INCIDENT_METHOD = exports.UPDATE_INCIDENT_JSON_HELP = exports.UPDATE_INCIDENT_JSON = exports.SUMMARY_REQUIRED = exports.STEP_4B_DESCRIPTION = exports.STEP_4B = exports.STEP_4A_DESCRIPTION = exports.STEP_4A = exports.STEP_4 = exports.STEP_3_DESCRIPTION = exports.STEP_3 = exports.STEP_2_DESCRIPTION = exports.STEP_2 = exports.STEP_1 = exports.STATUS_OPEN = exports.STATUS_IN_PROGRESS = exports.STATUS_CLOSED = exports.SEVERITY_MEDIUM_LABEL = exports.SEVERITY_LOW_LABEL = exports.SEVERITY_HIGH_LABEL = exports.SEVERITY_CRITICAL_LABEL = exports.PREVIOUS = exports.PASSWORD_REQUIRED = exports.PASSWORD = exports.NEXT = exports.MISSING_VARIABLES = exports.KEY_LABEL = exports.JSON = exports.HEADERS_TITLE = exports.HEADERS_SWITCH = exports.HAS_AUTH = exports.GET_RESPONSE_EXTERNAL_UPDATED_KEY_REQUIRED = exports.GET_RESPONSE_EXTERNAL_TITLE_KEY_REQUIRED = exports.GET_RESPONSE_EXTERNAL_CREATED_KEY_REQUIRED = exports.GET_INCIDENT_VIEW_URL_REQUIRED = exports.GET_INCIDENT_URL_REQUIRED = exports.GET_INCIDENT_URL_HELP = exports.GET_INCIDENT_URL = exports.GET_INCIDENT_TITLE_KEY_HELP = exports.GET_INCIDENT_TITLE_KEY = exports.EXTERNAL_TITLE_DESC = exports.EXTERNAL_INCIDENT_VIEW_URL_HELP = exports.EXTERNAL_INCIDENT_VIEW_URL = exports.EXTERNAL_ID_DESC = exports.DOC_LINK = exports.DELETE_BUTTON = exports.CREATE_URL_REQUIRED = exports.CREATE_RESPONSE_KEY_REQUIRED = exports.CREATE_METHOD_REQUIRED = exports.CREATE_INCIDENT_URL = exports.CREATE_INCIDENT_RESPONSE_KEY_HELP = exports.CREATE_INCIDENT_RESPONSE_KEY = exports.CREATE_INCIDENT_REQUIRED = exports.CREATE_INCIDENT_METHOD = exports.CREATE_INCIDENT_JSON_HELP = exports.CREATE_INCIDENT_JSON = exports.CREATE_COMMENT_URL_REQUIRED = exports.CREATE_COMMENT_URL_HELP = exports.CREATE_COMMENT_URL = exports.CREATE_COMMENT_METHOD_REQUIRED = exports.CREATE_COMMENT_METHOD = exports.CREATE_COMMENT_MESSAGE = exports.CREATE_COMMENT_JSON_HELP = exports.CREATE_COMMENT_JSON = exports.CODE_EDITOR = exports.CASE_TITLE_DESC = exports.CASE_TAGS_DESC = exports.CASE_STATUS_DESC = exports.CASE_SEVERITY_DESC = exports.CASE_ID_DESC = exports.CASE_DESCRIPTION_DESC = exports.CASE_COMMENT_DESC = exports.AUTH_TITLE = exports.ADD_CASES_VARIABLE = exports.ADD_BUTTON = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CREATE_URL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateUrlText', {
  defaultMessage: 'Create case URL is required.'
});
exports.CREATE_URL_REQUIRED = CREATE_URL_REQUIRED;
const CREATE_INCIDENT_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateIncidentText', {
  defaultMessage: 'Create case object is required and must be valid JSON.'
});
exports.CREATE_INCIDENT_REQUIRED = CREATE_INCIDENT_REQUIRED;
const CREATE_METHOD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateMethodText', {
  defaultMessage: 'Create case method is required.'
});
exports.CREATE_METHOD_REQUIRED = CREATE_METHOD_REQUIRED;
const CREATE_RESPONSE_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateIncidentResponseKeyText', {
  defaultMessage: 'Create case response case id key is required.'
});
exports.CREATE_RESPONSE_KEY_REQUIRED = CREATE_RESPONSE_KEY_REQUIRED;
const UPDATE_URL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredUpdateUrlText', {
  defaultMessage: 'Update case URL is required.'
});
exports.UPDATE_URL_REQUIRED = UPDATE_URL_REQUIRED;
const UPDATE_INCIDENT_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredUpdateIncidentText', {
  defaultMessage: 'Update case object is required and must be valid JSON.'
});
exports.UPDATE_INCIDENT_REQUIRED = UPDATE_INCIDENT_REQUIRED;
const UPDATE_METHOD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredUpdateMethodText', {
  defaultMessage: 'Update case method is required.'
});
exports.UPDATE_METHOD_REQUIRED = UPDATE_METHOD_REQUIRED;
const CREATE_COMMENT_URL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateCommentUrlText', {
  defaultMessage: 'Create comment URL must be URL format.'
});
exports.CREATE_COMMENT_URL_REQUIRED = CREATE_COMMENT_URL_REQUIRED;
const CREATE_COMMENT_MESSAGE = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateCommentIncidentText', {
  defaultMessage: 'Create comment object must be valid JSON.'
});
exports.CREATE_COMMENT_MESSAGE = CREATE_COMMENT_MESSAGE;
const CREATE_COMMENT_METHOD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateCommentMethodText', {
  defaultMessage: 'Create comment method is required.'
});
exports.CREATE_COMMENT_METHOD_REQUIRED = CREATE_COMMENT_METHOD_REQUIRED;
const GET_INCIDENT_URL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredGetIncidentUrlText', {
  defaultMessage: 'Get case URL is required.'
});
exports.GET_INCIDENT_URL_REQUIRED = GET_INCIDENT_URL_REQUIRED;
const GET_RESPONSE_EXTERNAL_TITLE_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredGetIncidentResponseExternalTitleKeyText', {
  defaultMessage: 'Get case response external case title key is re quired.'
});
exports.GET_RESPONSE_EXTERNAL_TITLE_KEY_REQUIRED = GET_RESPONSE_EXTERNAL_TITLE_KEY_REQUIRED;
const GET_RESPONSE_EXTERNAL_CREATED_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredGetIncidentResponseCreatedKeyText', {
  defaultMessage: 'Get case response created date key is required.'
});
exports.GET_RESPONSE_EXTERNAL_CREATED_KEY_REQUIRED = GET_RESPONSE_EXTERNAL_CREATED_KEY_REQUIRED;
const GET_RESPONSE_EXTERNAL_UPDATED_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredGetIncidentResponseUpdatedKeyText', {
  defaultMessage: 'Get case response updated date key is required.'
});
exports.GET_RESPONSE_EXTERNAL_UPDATED_KEY_REQUIRED = GET_RESPONSE_EXTERNAL_UPDATED_KEY_REQUIRED;
const GET_INCIDENT_VIEW_URL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredGetIncidentViewUrlKeyText', {
  defaultMessage: 'View case URL is required.'
});
exports.GET_INCIDENT_VIEW_URL_REQUIRED = GET_INCIDENT_VIEW_URL_REQUIRED;
const MISSING_VARIABLES = variables => _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.missingVariables', {
  defaultMessage: 'Missing required {variableCount, plural, one {variable} other {variables}}: {variables}',
  values: {
    variableCount: variables.length,
    variables: variables.join(', ')
  }
});
exports.MISSING_VARIABLES = MISSING_VARIABLES;
const USERNAME_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredAuthUserNameText', {
  defaultMessage: 'Username is required.'
});
exports.USERNAME_REQUIRED = USERNAME_REQUIRED;
const PASSWORD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredAuthPasswordText', {
  defaultMessage: 'Password is required.'
});
exports.PASSWORD_REQUIRED = PASSWORD_REQUIRED;
const SUMMARY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredWebhookSummaryText', {
  defaultMessage: 'Title is required.'
});
exports.SUMMARY_REQUIRED = SUMMARY_REQUIRED;
const KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.keyTextFieldLabel', {
  defaultMessage: 'Key'
});
exports.KEY_LABEL = KEY_LABEL;
const VALUE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.valueTextFieldLabel', {
  defaultMessage: 'Value'
});
exports.VALUE_LABEL = VALUE_LABEL;
const ADD_BUTTON = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.addHeaderButton', {
  defaultMessage: 'Add'
});
exports.ADD_BUTTON = ADD_BUTTON;
const DELETE_BUTTON = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.deleteHeaderButton', {
  defaultMessage: 'Delete',
  description: 'Delete HTTP header'
});
exports.DELETE_BUTTON = DELETE_BUTTON;
const CREATE_INCIDENT_METHOD = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createIncidentMethodTextFieldLabel', {
  defaultMessage: 'Create Case Method'
});
exports.CREATE_INCIDENT_METHOD = CREATE_INCIDENT_METHOD;
const CREATE_INCIDENT_URL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createIncidentUrlTextFieldLabel', {
  defaultMessage: 'Create Case URL'
});
exports.CREATE_INCIDENT_URL = CREATE_INCIDENT_URL;
const CREATE_INCIDENT_JSON = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createIncidentJsonTextFieldLabel', {
  defaultMessage: 'Create Case Object'
});
exports.CREATE_INCIDENT_JSON = CREATE_INCIDENT_JSON;
const CREATE_INCIDENT_JSON_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createIncidentJsonHelpText', {
  defaultMessage: 'JSON object to create case. Use the variable selector to add Cases data to the payload.'
});
exports.CREATE_INCIDENT_JSON_HELP = CREATE_INCIDENT_JSON_HELP;
const JSON = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.jsonFieldLabel', {
  defaultMessage: 'JSON'
});
exports.JSON = JSON;
const CODE_EDITOR = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.jsonCodeEditorAriaLabel', {
  defaultMessage: 'Code editor'
});
exports.CODE_EDITOR = CODE_EDITOR;
const CREATE_INCIDENT_RESPONSE_KEY = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createIncidentResponseKeyTextFieldLabel', {
  defaultMessage: 'Create Case Response Case Key'
});
exports.CREATE_INCIDENT_RESPONSE_KEY = CREATE_INCIDENT_RESPONSE_KEY;
const CREATE_INCIDENT_RESPONSE_KEY_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createIncidentResponseKeyHelpText', {
  defaultMessage: 'JSON key in create case response that contains the external case id'
});
exports.CREATE_INCIDENT_RESPONSE_KEY_HELP = CREATE_INCIDENT_RESPONSE_KEY_HELP;
const ADD_CASES_VARIABLE = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.addVariable', {
  defaultMessage: 'Add variable'
});
exports.ADD_CASES_VARIABLE = ADD_CASES_VARIABLE;
const GET_INCIDENT_URL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.getIncidentUrlTextFieldLabel', {
  defaultMessage: 'Get Case URL'
});
exports.GET_INCIDENT_URL = GET_INCIDENT_URL;
const GET_INCIDENT_URL_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.getIncidentUrlHelp', {
  defaultMessage: 'API URL to GET case details JSON from external system. Use the variable selector to add external system id to the url.'
});
exports.GET_INCIDENT_URL_HELP = GET_INCIDENT_URL_HELP;
const GET_INCIDENT_TITLE_KEY = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.getIncidentResponseExternalTitleKeyTextFieldLabel', {
  defaultMessage: 'Get Case Response External Title Key'
});
exports.GET_INCIDENT_TITLE_KEY = GET_INCIDENT_TITLE_KEY;
const GET_INCIDENT_TITLE_KEY_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.getIncidentResponseExternalTitleKeyHelp', {
  defaultMessage: 'JSON key in get case response that contains the external case title'
});
exports.GET_INCIDENT_TITLE_KEY_HELP = GET_INCIDENT_TITLE_KEY_HELP;
const EXTERNAL_INCIDENT_VIEW_URL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.viewIncidentUrlTextFieldLabel', {
  defaultMessage: 'External Case View URL'
});
exports.EXTERNAL_INCIDENT_VIEW_URL = EXTERNAL_INCIDENT_VIEW_URL;
const EXTERNAL_INCIDENT_VIEW_URL_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.viewIncidentUrlHelp', {
  defaultMessage: 'URL to view case in external system. Use the variable selector to add external system id or external system title to the url.'
});
exports.EXTERNAL_INCIDENT_VIEW_URL_HELP = EXTERNAL_INCIDENT_VIEW_URL_HELP;
const UPDATE_INCIDENT_METHOD = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.updateIncidentMethodTextFieldLabel', {
  defaultMessage: 'Update Case Method'
});
exports.UPDATE_INCIDENT_METHOD = UPDATE_INCIDENT_METHOD;
const UPDATE_INCIDENT_URL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.updateIncidentUrlTextFieldLabel', {
  defaultMessage: 'Update Case URL'
});
exports.UPDATE_INCIDENT_URL = UPDATE_INCIDENT_URL;
const UPDATE_INCIDENT_URL_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.updateIncidentUrlHelp', {
  defaultMessage: 'API URL to update case.'
});
exports.UPDATE_INCIDENT_URL_HELP = UPDATE_INCIDENT_URL_HELP;
const UPDATE_INCIDENT_JSON = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.updateIncidentJsonTextFieldLabel', {
  defaultMessage: 'Update Case Object'
});
exports.UPDATE_INCIDENT_JSON = UPDATE_INCIDENT_JSON;
const UPDATE_INCIDENT_JSON_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.updateIncidentJsonHelpl', {
  defaultMessage: 'JSON object to update case. Use the variable selector to add Cases data to the payload.'
});
exports.UPDATE_INCIDENT_JSON_HELP = UPDATE_INCIDENT_JSON_HELP;
const CREATE_COMMENT_METHOD = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createCommentMethodTextFieldLabel', {
  defaultMessage: 'Create Comment Method'
});
exports.CREATE_COMMENT_METHOD = CREATE_COMMENT_METHOD;
const CREATE_COMMENT_URL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createCommentUrlTextFieldLabel', {
  defaultMessage: 'Create Comment URL'
});
exports.CREATE_COMMENT_URL = CREATE_COMMENT_URL;
const CREATE_COMMENT_URL_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createCommentUrlHelp', {
  defaultMessage: 'API URL to add comment to case.'
});
exports.CREATE_COMMENT_URL_HELP = CREATE_COMMENT_URL_HELP;
const CREATE_COMMENT_JSON = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createCommentJsonTextFieldLabel', {
  defaultMessage: 'Create Comment Object'
});
exports.CREATE_COMMENT_JSON = CREATE_COMMENT_JSON;
const CREATE_COMMENT_JSON_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createCommentJsonHelp', {
  defaultMessage: 'JSON object to create a comment. Use the variable selector to add Cases data to the payload.'
});
exports.CREATE_COMMENT_JSON_HELP = CREATE_COMMENT_JSON_HELP;
const HAS_AUTH = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.hasAuthSwitchLabel', {
  defaultMessage: 'Require authentication for this webhook'
});
exports.HAS_AUTH = HAS_AUTH;
const USERNAME = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.userTextFieldLabel', {
  defaultMessage: 'Username'
});
exports.USERNAME = USERNAME;
const PASSWORD = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.passwordTextFieldLabel', {
  defaultMessage: 'Password'
});
exports.PASSWORD = PASSWORD;
const HEADERS_SWITCH = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.viewHeadersSwitch', {
  defaultMessage: 'Add HTTP header'
});
exports.HEADERS_SWITCH = HEADERS_SWITCH;
const HEADERS_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.httpHeadersTitle', {
  defaultMessage: 'Headers in use'
});
exports.HEADERS_TITLE = HEADERS_TITLE;
const AUTH_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.authenticationLabel', {
  defaultMessage: 'Authentication'
});
exports.AUTH_TITLE = AUTH_TITLE;
const STEP_1 = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step1', {
  defaultMessage: 'Set up connector'
});
exports.STEP_1 = STEP_1;
const STEP_2 = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step2', {
  defaultMessage: 'Create case'
});
exports.STEP_2 = STEP_2;
const STEP_2_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step2Description', {
  defaultMessage: 'Set fields to create the case in the external system. Check your service’s API documentation to understand what fields are required'
});
exports.STEP_2_DESCRIPTION = STEP_2_DESCRIPTION;
const STEP_3 = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step3', {
  defaultMessage: 'Get case information'
});
exports.STEP_3 = STEP_3;
const STEP_3_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step3Description', {
  defaultMessage: 'Set fields to add comments to the case in external system. For some systems, this may be the same method as creating updates in cases. Check your service’s API documentation to understand what fields are required.'
});
exports.STEP_3_DESCRIPTION = STEP_3_DESCRIPTION;
const STEP_4 = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step4', {
  defaultMessage: 'Comments and updates'
});
exports.STEP_4 = STEP_4;
const STEP_4A = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step4a', {
  defaultMessage: 'Create update in case'
});
exports.STEP_4A = STEP_4A;
const STEP_4A_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step4aDescription', {
  defaultMessage: 'Set fields to create updates to the case in external system. For some systems, this may be the same method as adding comments to cases.'
});
exports.STEP_4A_DESCRIPTION = STEP_4A_DESCRIPTION;
const STEP_4B = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step4b', {
  defaultMessage: 'Add comment in case'
});
exports.STEP_4B = STEP_4B;
const STEP_4B_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step4bDescription', {
  defaultMessage: 'Set fields to add comments to the case in external system. For some systems, this may be the same method as creating updates in cases.'
});
exports.STEP_4B_DESCRIPTION = STEP_4B_DESCRIPTION;
const NEXT = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.next', {
  defaultMessage: 'Next'
});
exports.NEXT = NEXT;
const PREVIOUS = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.previous', {
  defaultMessage: 'Previous'
});
exports.PREVIOUS = PREVIOUS;
const CASE_TITLE_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseTitleDesc', {
  defaultMessage: 'Kibana case title'
});
exports.CASE_TITLE_DESC = CASE_TITLE_DESC;
const CASE_DESCRIPTION_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseDescriptionDesc', {
  defaultMessage: 'Kibana case description'
});
exports.CASE_DESCRIPTION_DESC = CASE_DESCRIPTION_DESC;
const CASE_TAGS_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseTagsDesc', {
  defaultMessage: 'Kibana case tags'
});
exports.CASE_TAGS_DESC = CASE_TAGS_DESC;
const CASE_ID_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseIdDesc', {
  defaultMessage: 'Kibana case id'
});
exports.CASE_ID_DESC = CASE_ID_DESC;
const CASE_SEVERITY_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseSeverityDesc', {
  defaultMessage: 'Kibana case severity'
});
exports.CASE_SEVERITY_DESC = CASE_SEVERITY_DESC;
const CASE_STATUS_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseStatusDesc', {
  defaultMessage: 'Kibana case status'
});
exports.CASE_STATUS_DESC = CASE_STATUS_DESC;
const CASE_COMMENT_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseCommentDesc', {
  defaultMessage: 'Kibana case comment'
});
exports.CASE_COMMENT_DESC = CASE_COMMENT_DESC;
const EXTERNAL_ID_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.externalIdDesc', {
  defaultMessage: 'External system id'
});
exports.EXTERNAL_ID_DESC = EXTERNAL_ID_DESC;
const EXTERNAL_TITLE_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.externalTitleDesc', {
  defaultMessage: 'External system title'
});
exports.EXTERNAL_TITLE_DESC = EXTERNAL_TITLE_DESC;
const DOC_LINK = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.docLink', {
  defaultMessage: 'Configuring Webhook - Case Management connector.'
});
exports.DOC_LINK = DOC_LINK;
const SEVERITY_CRITICAL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.criticalLabel', {
  defaultMessage: 'Critical'
});
exports.SEVERITY_CRITICAL_LABEL = SEVERITY_CRITICAL_LABEL;
const SEVERITY_HIGH_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.highLabel', {
  defaultMessage: 'High'
});
exports.SEVERITY_HIGH_LABEL = SEVERITY_HIGH_LABEL;
const SEVERITY_MEDIUM_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.mediumLabel', {
  defaultMessage: 'Medium'
});
exports.SEVERITY_MEDIUM_LABEL = SEVERITY_MEDIUM_LABEL;
const SEVERITY_LOW_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.lowLabel', {
  defaultMessage: 'Low'
});
exports.SEVERITY_LOW_LABEL = SEVERITY_LOW_LABEL;
const STATUS_OPEN = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.status.open', {
  defaultMessage: 'Open'
});
exports.STATUS_OPEN = STATUS_OPEN;
const STATUS_CLOSED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.status.closed', {
  defaultMessage: 'Closed'
});
exports.STATUS_CLOSED = STATUS_CLOSED;
const STATUS_IN_PROGRESS = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.status.inProgress', {
  defaultMessage: 'In progress'
});
exports.STATUS_IN_PROGRESS = STATUS_IN_PROGRESS;