"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statuses = exports.caseStatuses = exports.StatusFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _casesComponents = require("@kbn/cases-components");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const caseStatuses = [_casesComponents.CaseStatuses.open, _casesComponents.CaseStatuses['in-progress'], _casesComponents.CaseStatuses.closed];
exports.caseStatuses = caseStatuses;
const statuses = {
  [_casesComponents.CaseStatuses.open]: {
    color: 'primary',
    label: i18n.STATUS_OPEN
  },
  [_casesComponents.CaseStatuses['in-progress']]: {
    color: 'warning',
    label: i18n.STATUS_IN_PROGRESS
  },
  [_casesComponents.CaseStatuses.closed]: {
    color: 'default',
    label: i18n.STATUS_CLOSED
  }
};
exports.statuses = statuses;
const StatusFilter = ({
  selectedStatus,
  onStatusChanged
}) => {
  const options = caseStatuses.map(status => {
    var _statuses$status, _statuses$status2;
    return {
      value: status,
      inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: 'center',
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        "data-test-subj": `case-status-badge-${status}`,
        color: (_statuses$status = statuses[status]) === null || _statuses$status === void 0 ? void 0 : _statuses$status.color
      }, (_statuses$status2 = statuses[status]) === null || _statuses$status2 === void 0 ? void 0 : _statuses$status2.label)))),
      'data-test-subj': `case-status-filter-${status}`
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: options,
    valueOfSelected: selectedStatus,
    onChange: onStatusChanged,
    "data-test-subj": "case-status-filter",
    fullWidth: true
  });
};
exports.StatusFilter = StatusFilter;
StatusFilter.displayName = 'StatusFilter';