"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USAGE_DASHBOARD_LINK = exports.URL_LABEL = exports.SECRET = exports.REGION_LABEL = exports.MODEL = exports.INVALID_ACTION = exports.DOCUMENTATION = exports.DEFAULT_MODEL_LABEL = exports.BODY_REQUIRED = exports.BODY_INVALID = exports.BODY_DESCRIPTION = exports.BODY = exports.BEDROCK = exports.API_URL_LABEL = exports.ACTION_REQUIRED = exports.ACCESS_KEY_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.apiUrlTextFieldLabel', {
  defaultMessage: 'URL'
});
exports.API_URL_LABEL = API_URL_LABEL;
const ACCESS_KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.accessKeySecret', {
  defaultMessage: 'Access Key'
});
exports.ACCESS_KEY_LABEL = ACCESS_KEY_LABEL;
const DEFAULT_MODEL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.defaultModelTextFieldLabel', {
  defaultMessage: 'Default model'
});
exports.DEFAULT_MODEL_LABEL = DEFAULT_MODEL_LABEL;
const REGION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.defaultRegionTextFieldLabel', {
  defaultMessage: 'AWS Region'
});
exports.REGION_LABEL = REGION_LABEL;
const SECRET = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.secret', {
  defaultMessage: 'Secret'
});
exports.SECRET = SECRET;
const BEDROCK = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.title', {
  defaultMessage: 'Amazon Bedrock'
});
exports.BEDROCK = BEDROCK;
const DOCUMENTATION = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.documentation', {
  defaultMessage: 'documentation'
});
exports.DOCUMENTATION = DOCUMENTATION;
const URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.urlTextFieldLabel', {
  defaultMessage: 'URL'
});
exports.URL_LABEL = URL_LABEL;
const BODY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.error.requiredBedrockBodyText', {
  defaultMessage: 'Body is required.'
});
exports.BODY_REQUIRED = BODY_REQUIRED;
const BODY_INVALID = _i18n.i18n.translate('xpack.stackConnectors.security.bedrock.params.error.invalidBodyText', {
  defaultMessage: 'Body does not have a valid JSON format.'
});
exports.BODY_INVALID = BODY_INVALID;
const ACTION_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.bedrock.params.error.requiredActionText', {
  defaultMessage: 'Action is required.'
});
exports.ACTION_REQUIRED = ACTION_REQUIRED;
const INVALID_ACTION = _i18n.i18n.translate('xpack.stackConnectors.security.bedrock.params.error.invalidActionText', {
  defaultMessage: 'Invalid action name.'
});
exports.INVALID_ACTION = INVALID_ACTION;
const BODY = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.bodyFieldLabel', {
  defaultMessage: 'Body'
});
exports.BODY = BODY;
const BODY_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.bodyCodeEditorAriaLabel', {
  defaultMessage: 'Code editor'
});
exports.BODY_DESCRIPTION = BODY_DESCRIPTION;
const MODEL = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.model', {
  defaultMessage: 'Model'
});
exports.MODEL = MODEL;
const USAGE_DASHBOARD_LINK = (apiProvider, connectorName) => _i18n.i18n.translate('xpack.stackConnectors.components.genAi.dashboardLink', {
  values: {
    apiProvider,
    connectorName
  },
  defaultMessage: 'View {apiProvider} Usage Dashboard for "{ connectorName }" Connector'
});
exports.USAGE_DASHBOARD_LINK = USAGE_DASHBOARD_LINK;