"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("./constants");
var _constants2 = require("../../../common/bedrock/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BedrockParamsFields = ({
  actionParams,
  editAction,
  index,
  messageVariables,
  executionMode,
  errors
}) => {
  const {
    subAction,
    subActionParams
  } = actionParams;
  const {
    body,
    model
  } = subActionParams !== null && subActionParams !== void 0 ? subActionParams : {};
  const isTest = (0, _react.useMemo)(() => executionMode === _public.ActionConnectorMode.Test, [executionMode]);
  (0, _react.useEffect)(() => {
    if (!subAction) {
      editAction('subAction', isTest ? _constants2.SUB_ACTION.TEST : _constants2.SUB_ACTION.RUN, index);
    }
  }, [editAction, index, isTest, subAction]);
  (0, _react.useEffect)(() => {
    if (!subActionParams) {
      editAction('subActionParams', {
        body: _constants.DEFAULT_BODY
      }, index);
    }
  }, [editAction, index, subActionParams]);
  (0, _react.useEffect)(() => {
    return () => {
      // some bedrock specific formatting gets messed up if we do not reset
      // subActionParams on dismount (switching tabs between test and config)
      editAction('subActionParams', undefined, index);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const editSubActionParams = (0, _react.useCallback)(params => {
    editAction('subActionParams', {
      ...subActionParams,
      ...params
    }, index);
  }, [editAction, index, subActionParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'body',
    inputTargetValue: body,
    label: i18n.BODY,
    "aria-label": i18n.BODY_DESCRIPTION,
    errors: errors.body,
    onDocumentsChange: json => {
      editSubActionParams({
        body: json
      });
    },
    onBlur: () => {
      if (!body) {
        editSubActionParams({
          body: ''
        });
      }
    },
    "data-test-subj": "bedrock-bodyJsonEditor"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.MODEL,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Optionally overwrite default model per request. Current support is for the Anthropic Claude models. For more information, refer to the {bedrockAPIModelDocs}.",
      id: "xpack.stackConnectors.components.bedrock.modelHelpText",
      values: {
        bedrockAPIModelDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "bedrock-api-model-doc",
          href: "https://aws.amazon.com/bedrock/claude/",
          target: "_blank"
        }, `${i18n.BEDROCK} ${i18n.DOCUMENTATION}`)
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "bedrock-model",
    placeholder: 'anthropic.claude-v2',
    value: model,
    onChange: ev => {
      editSubActionParams({
        model: ev.target.value
      });
    },
    fullWidth: true
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = BedrockParamsFields;
module.exports = exports.default;