"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUB_ACTION = exports.OpenAiProviderType = exports.OPENAI_TITLE = exports.OPENAI_LEGACY_COMPLETION_URL = exports.OPENAI_CONNECTOR_ID = exports.OPENAI_CHAT_URL = exports.DEFAULT_OPENAI_MODEL = exports.AZURE_OPENAI_COMPLETIONS_URL = exports.AZURE_OPENAI_COMPLETIONS_EXTENSIONS_URL = exports.AZURE_OPENAI_CHAT_URL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPENAI_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.connectorTypeTitle', {
  defaultMessage: 'OpenAI'
});
exports.OPENAI_TITLE = OPENAI_TITLE;
const OPENAI_CONNECTOR_ID = '.gen-ai';
exports.OPENAI_CONNECTOR_ID = OPENAI_CONNECTOR_ID;
let SUB_ACTION;
exports.SUB_ACTION = SUB_ACTION;
(function (SUB_ACTION) {
  SUB_ACTION["RUN"] = "run";
  SUB_ACTION["INVOKE_AI"] = "invokeAI";
  SUB_ACTION["INVOKE_STREAM"] = "invokeStream";
  SUB_ACTION["STREAM"] = "stream";
  SUB_ACTION["DASHBOARD"] = "getDashboard";
  SUB_ACTION["TEST"] = "test";
})(SUB_ACTION || (exports.SUB_ACTION = SUB_ACTION = {}));
let OpenAiProviderType;
exports.OpenAiProviderType = OpenAiProviderType;
(function (OpenAiProviderType) {
  OpenAiProviderType["OpenAi"] = "OpenAI";
  OpenAiProviderType["AzureAi"] = "Azure OpenAI";
})(OpenAiProviderType || (exports.OpenAiProviderType = OpenAiProviderType = {}));
const DEFAULT_OPENAI_MODEL = 'gpt-4';
exports.DEFAULT_OPENAI_MODEL = DEFAULT_OPENAI_MODEL;
const OPENAI_CHAT_URL = 'https://api.openai.com/v1/chat/completions';
exports.OPENAI_CHAT_URL = OPENAI_CHAT_URL;
const OPENAI_LEGACY_COMPLETION_URL = 'https://api.openai.com/v1/completions';
exports.OPENAI_LEGACY_COMPLETION_URL = OPENAI_LEGACY_COMPLETION_URL;
const AZURE_OPENAI_CHAT_URL = 'https://{your-resource-name}.openai.azure.com/openai/deployments/{deployment-id}/chat/completions?api-version={api-version}';
exports.AZURE_OPENAI_CHAT_URL = AZURE_OPENAI_CHAT_URL;
const AZURE_OPENAI_COMPLETIONS_URL = 'https://{your-resource-name}.openai.azure.com/openai/deployments/{deployment-id}/completions?api-version={api-version}';
exports.AZURE_OPENAI_COMPLETIONS_URL = AZURE_OPENAI_COMPLETIONS_URL;
const AZURE_OPENAI_COMPLETIONS_EXTENSIONS_URL = 'https://{your-resource-name}.openai.azure.com/openai/deployments/{deployment-id}/extensions/chat/completions?api-version={api-version}';
exports.AZURE_OPENAI_COMPLETIONS_EXTENSIONS_URL = AZURE_OPENAI_COMPLETIONS_EXTENSIONS_URL;