"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQueryDsl = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getQueryDsl = (query, indexPattern) => {
  if (query.language === 'kuery') {
    return (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(query.query), indexPattern);
  }
  return (0, _esQuery.luceneStringToDsl)(query.query);
};
exports.getQueryDsl = getQueryDsl;