"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsQueryExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _public3 = require("@kbn/triggers-actions-ui-plugin/public");
var _common = require("@kbn/alerting-plugin/common");
var _common2 = require("@kbn/triggers-actions-ui-plugin/public/common");
var _common3 = require("../../../../common");
var _validation = require("../validation");
var _build_sorted_events_query = require("../../../../common/build_sorted_events_query");
var _types = require("../types");
var _index_select_popover = require("../../components/index_select_popover");
var _constants = require("../constants");
var _rule_common_expressions = require("../rule_common_expressions");
var _util = require("../util");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  useXJsonMode
} = _public.XJson;
const EsQueryExpression = ({
  ruleParams,
  setRuleParams,
  setRuleProperty,
  errors,
  data
}) => {
  const {
    index,
    timeField,
    esQuery,
    size,
    thresholdComparator,
    threshold,
    timeWindowSize,
    timeWindowUnit,
    aggType,
    aggField,
    groupBy,
    termSize,
    termField,
    excludeHitsFromPreviousRun
  } = ruleParams;
  const [currentRuleParams, setCurrentRuleParams] = (0, _react.useState)({
    ...ruleParams,
    timeWindowSize: timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : _constants.DEFAULT_VALUES.TIME_WINDOW_SIZE,
    timeWindowUnit: timeWindowUnit !== null && timeWindowUnit !== void 0 ? timeWindowUnit : _constants.DEFAULT_VALUES.TIME_WINDOW_UNIT,
    threshold: threshold !== null && threshold !== void 0 ? threshold : _constants.DEFAULT_VALUES.THRESHOLD,
    thresholdComparator: thresholdComparator !== null && thresholdComparator !== void 0 ? thresholdComparator : _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR,
    size: size !== null && size !== void 0 ? size : _constants.DEFAULT_VALUES.SIZE,
    esQuery: esQuery !== null && esQuery !== void 0 ? esQuery : _constants.DEFAULT_VALUES.QUERY,
    aggType: aggType !== null && aggType !== void 0 ? aggType : _constants.DEFAULT_VALUES.AGGREGATION_TYPE,
    groupBy: groupBy !== null && groupBy !== void 0 ? groupBy : _constants.DEFAULT_VALUES.GROUP_BY,
    termSize: termSize !== null && termSize !== void 0 ? termSize : _constants.DEFAULT_VALUES.TERM_SIZE,
    searchType: _types.SearchType.esQuery,
    excludeHitsFromPreviousRun: excludeHitsFromPreviousRun !== null && excludeHitsFromPreviousRun !== void 0 ? excludeHitsFromPreviousRun : _constants.DEFAULT_VALUES.EXCLUDE_PREVIOUS_HITS
  });
  const setParam = (0, _react.useCallback)((paramField, paramValue) => {
    setCurrentRuleParams(currentParams => ({
      ...currentParams,
      [paramField]: paramValue
    }));
    setRuleParams(paramField, paramValue);
  }, [setRuleParams]);
  const services = (0, _util.useTriggerUiActionServices)();
  const {
    http,
    docLinks
  } = services;
  const [esFields, setEsFields] = (0, _react.useState)([]);
  const [runtimeFields, setRuntimeFields] = (0, _react.useState)([]);
  const [combinedFields, setCombinedFields] = (0, _react.useState)([]);
  const {
    convertToJson,
    setXJson,
    xJson
  } = useXJsonMode(_constants.DEFAULT_VALUES.QUERY);
  const setDefaultExpressionValues = async () => {
    setRuleProperty('params', currentRuleParams);
    setXJson(esQuery !== null && esQuery !== void 0 ? esQuery : _constants.DEFAULT_VALUES.QUERY);
    if (index && index.length > 0) {
      await refreshEsFields(index);
    }
  };
  (0, _react.useEffect)(() => {
    setDefaultExpressionValues();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const refreshEsFields = async indices => {
    const currentEsFields = await (0, _public3.getFields)(http, indices);
    setEsFields(currentEsFields);
    setCombinedFields((0, _lodash.sortBy)(currentEsFields.concat(runtimeFields), 'name'));
  };
  const getRuntimeFields = xjson => {
    let runtimeMappings;
    try {
      runtimeMappings = (0, _lodash.get)(JSON.parse(xjson), 'runtime_mappings');
    } catch (e) {
      // ignore error
    }
    if (runtimeMappings) {
      const currentRuntimeFields = (0, _util.convertRawRuntimeFieldtoFieldOption)(runtimeMappings);
      setRuntimeFields(currentRuntimeFields);
      setCombinedFields((0, _lodash.sortBy)(esFields.concat(currentRuntimeFields), 'name'));
    }
  };
  const onTestQuery = (0, _react.useCallback)(async () => {
    const isGroupAgg = (0, _common2.isGroupAggregation)(termField);
    const isCountAgg = (0, _common2.isCountAggregation)(aggType);
    const window = `${timeWindowSize}${timeWindowUnit}`;
    if ((0, _validation.hasExpressionValidationErrors)(currentRuleParams)) {
      return {
        testResults: {
          results: [],
          truncated: false
        },
        isGrouped: isGroupAgg,
        timeWindow: window
      };
    }
    const timeWindow = (0, _common.parseDuration)(window);
    const parsedQuery = JSON.parse(esQuery);
    const now = Date.now();
    const {
      rawResponse
    } = await (0, _rxjs.lastValueFrom)(data.search.search({
      params: (0, _build_sorted_events_query.buildSortedEventsQuery)({
        index,
        from: new Date(now - timeWindow).toISOString(),
        to: new Date(now).toISOString(),
        filter: parsedQuery.query,
        size: 0,
        searchAfterSortId: undefined,
        timeField: timeField ? timeField : '',
        track_total_hits: true,
        aggs: (0, _common2.buildAggregation)({
          aggType,
          aggField,
          termField,
          termSize,
          condition: {
            conditionScript: (0, _common3.getComparatorScript)(thresholdComparator !== null && thresholdComparator !== void 0 ? thresholdComparator : _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR, threshold, _common2.BUCKET_SELECTOR_FIELD)
          }
        })
      })
    }));
    return {
      testResults: (0, _common2.parseAggregationResults)({
        isCountAgg,
        isGroupAgg,
        esResult: rawResponse
      }),
      isGrouped: isGroupAgg,
      timeWindow: window
    };
  }, [timeWindowSize, timeWindowUnit, currentRuleParams, esQuery, data.search, index, timeField, aggType, aggField, termField, termSize, threshold, thresholdComparator]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.selectIndexPrompt",
    defaultMessage: "Select indices"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_index_select_popover.IndexSelectPopover, {
    index: index,
    "data-test-subj": "indexSelectPopover",
    esFields: esFields,
    timeField: timeField,
    errors: errors,
    onIndexChange: async indices => {
      setParam('index', indices);

      // reset expression fields if indices are deleted
      if (indices.length === 0) {
        setRuleProperty('params', {
          timeField: ruleParams.timeField,
          index: indices,
          esQuery: _constants.DEFAULT_VALUES.QUERY,
          size: _constants.DEFAULT_VALUES.SIZE,
          thresholdComparator: _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR,
          timeWindowSize: _constants.DEFAULT_VALUES.TIME_WINDOW_SIZE,
          timeWindowUnit: _constants.DEFAULT_VALUES.TIME_WINDOW_UNIT,
          threshold: _constants.DEFAULT_VALUES.THRESHOLD,
          aggType: _constants.DEFAULT_VALUES.AGGREGATION_TYPE,
          groupBy: _constants.DEFAULT_VALUES.GROUP_BY,
          termSize: _constants.DEFAULT_VALUES.TERM_SIZE,
          searchType: _types.SearchType.esQuery,
          excludeHitsFromPreviousRun: _constants.DEFAULT_VALUES.EXCLUDE_PREVIOUS_HITS
        });
      } else {
        await refreshEsFields(indices);
      }
    },
    onTimeFieldChange: updatedTimeField => setParam('timeField', updatedTimeField)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.defineQueryPrompt",
    defaultMessage: "Define your query using Query DSL"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "queryEditor",
    "data-test-subj": "queryJsonEditor",
    fullWidth: true,
    isInvalid: errors.esQuery.length > 0,
    error: errors.esQuery,
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.query.queryDsl,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.queryPrompt.help",
      defaultMessage: "Elasticsearch Query DSL documentation"
    }))
  }, /*#__PURE__*/_react.default.createElement(_public2.CodeEditor, {
    languageId: "xjson",
    width: "100%",
    height: "200px",
    value: xJson,
    onChange: xjson => {
      setXJson(xjson);
      setParam('esQuery', convertToJson(xjson));
      getRuntimeFields(xjson);
    },
    options: {
      ariaLabel: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.queryEditor', {
        defaultMessage: 'Elasticsearch query editor'
      }),
      wordWrap: 'off',
      tabSize: 2,
      lineNumbers: 'off',
      lineNumbersMinChars: 0,
      folding: false,
      lineDecorationsWidth: 0,
      overviewRulerBorder: false
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_rule_common_expressions.RuleCommonExpressions, {
    threshold: threshold !== null && threshold !== void 0 ? threshold : _constants.DEFAULT_VALUES.THRESHOLD,
    thresholdComparator: thresholdComparator !== null && thresholdComparator !== void 0 ? thresholdComparator : _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR,
    timeWindowSize: timeWindowSize,
    timeWindowUnit: timeWindowUnit,
    size: size,
    esFields: combinedFields,
    aggType: aggType,
    aggField: aggField,
    groupBy: groupBy,
    termSize: termSize,
    termField: termField,
    onChangeSelectedAggField: (0, _react.useCallback)(selectedAggField => setParam('aggField', selectedAggField), [setParam]),
    onChangeSelectedAggType: (0, _react.useCallback)(selectedAggType => setParam('aggType', selectedAggType), [setParam]),
    onChangeSelectedGroupBy: (0, _react.useCallback)(selectedGroupBy => setParam('groupBy', selectedGroupBy), [setParam]),
    onChangeSelectedTermField: (0, _react.useCallback)(selectedTermField => setParam('termField', selectedTermField), [setParam]),
    onChangeSelectedTermSize: (0, _react.useCallback)(selectedTermSize => setParam('termSize', selectedTermSize), [setParam]),
    onChangeThreshold: (0, _react.useCallback)(selectedThresholds => setParam('threshold', selectedThresholds), [setParam]),
    onChangeThresholdComparator: (0, _react.useCallback)(selectedThresholdComparator => setParam('thresholdComparator', selectedThresholdComparator), [setParam]),
    onChangeWindowSize: (0, _react.useCallback)(selectedWindowSize => setParam('timeWindowSize', selectedWindowSize), [setParam]),
    onChangeWindowUnit: (0, _react.useCallback)(selectedWindowUnit => setParam('timeWindowUnit', selectedWindowUnit), [setParam]),
    onChangeSizeValue: (0, _react.useCallback)(updatedValue => setParam('size', updatedValue), [setParam]),
    errors: errors,
    hasValidationErrors: (0, _validation.hasExpressionValidationErrors)(currentRuleParams),
    onTestFetch: onTestQuery,
    excludeHitsFromPreviousRun: excludeHitsFromPreviousRun,
    onChangeExcludeHitsFromPreviousRun: (0, _react.useCallback)(exclude => setParam('excludeHitsFromPreviousRun', exclude), [setParam]),
    canSelectMultiTerms: _constants.DEFAULT_VALUES.CAN_SELECT_MULTI_TERMS
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.EsQueryExpression = EsQueryExpression;