"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEARCH_SOURCE_ONLY_EXPRESSION_ERRORS = exports.ONLY_ES_QUERY_EXPRESSION_ERRORS = exports.ONLY_ESQL_QUERY_EXPRESSION_ERRORS = exports.DEFAULT_VALUES = exports.COMMON_EXPRESSION_ERRORS = exports.ALL_EXPRESSION_ERROR_KEYS = void 0;
var _public = require("@kbn/triggers-actions-ui-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_VALUES = {
  THRESHOLD_COMPARATOR: _public.COMPARATORS.GREATER_THAN,
  QUERY: `{
    "query":{
      "match_all" : {}
    }
  }`,
  SIZE: 100,
  TIME_WINDOW_SIZE: 5,
  TIME_WINDOW_UNIT: 'm',
  THRESHOLD: [1000],
  AGGREGATION_TYPE: 'count',
  TERM_SIZE: 5,
  GROUP_BY: 'all',
  EXCLUDE_PREVIOUS_HITS: true,
  CAN_SELECT_MULTI_TERMS: true
};
exports.DEFAULT_VALUES = DEFAULT_VALUES;
const COMMON_EXPRESSION_ERRORS = {
  searchType: new Array(),
  threshold0: new Array(),
  threshold1: new Array(),
  timeWindowSize: new Array(),
  size: new Array(),
  aggField: new Array(),
  aggType: new Array(),
  groupBy: new Array(),
  termSize: new Array(),
  termField: new Array()
};
exports.COMMON_EXPRESSION_ERRORS = COMMON_EXPRESSION_ERRORS;
const SEARCH_SOURCE_ONLY_EXPRESSION_ERRORS = {
  searchConfiguration: new Array(),
  timeField: new Array()
};
exports.SEARCH_SOURCE_ONLY_EXPRESSION_ERRORS = SEARCH_SOURCE_ONLY_EXPRESSION_ERRORS;
const ONLY_ES_QUERY_EXPRESSION_ERRORS = {
  index: new Array(),
  esQuery: new Array(),
  timeField: new Array()
};
exports.ONLY_ES_QUERY_EXPRESSION_ERRORS = ONLY_ES_QUERY_EXPRESSION_ERRORS;
const ONLY_ESQL_QUERY_EXPRESSION_ERRORS = {
  esqlQuery: new Array(),
  timeField: new Array(),
  thresholdComparator: new Array(),
  threshold0: new Array()
};
exports.ONLY_ESQL_QUERY_EXPRESSION_ERRORS = ONLY_ESQL_QUERY_EXPRESSION_ERRORS;
const ALL_EXPRESSION_ERROR_ENTRIES = {
  ...COMMON_EXPRESSION_ERRORS,
  ...SEARCH_SOURCE_ONLY_EXPRESSION_ERRORS,
  ...ONLY_ES_QUERY_EXPRESSION_ERRORS
};
const ALL_EXPRESSION_ERROR_KEYS = Object.keys(ALL_EXPRESSION_ERROR_ENTRIES);
exports.ALL_EXPRESSION_ERROR_KEYS = ALL_EXPRESSION_ERROR_KEYS;