"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareToSpaceForm = void 0;
require("./share_to_space_form.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _share_mode_control = require("./share_mode_control");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShareToSpaceForm = props => {
  const {
    spaces,
    objectNoun,
    onUpdate,
    shareOptions,
    showCreateCopyCallout,
    canShareToAllSpaces,
    makeCopy,
    enableCreateNewSpaceLink,
    enableSpaceAgnosticBehavior,
    prohibitedSpaces
  } = props;
  const setSelectedSpaceIds = selectedSpaceIds => onUpdate({
    ...shareOptions,
    selectedSpaceIds
  });
  const createCopyCallout = showCreateCopyCallout ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.shareToSpace.shareWarningTitle",
      defaultMessage: "Changes are synchronized across spaces"
    }),
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.shareToSpace.shareWarningBody",
    defaultMessage: "Your changes appear in each space you select. {makeACopyLink} if you don't want to synchronize your changes.",
    values: {
      makeACopyLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "sts-copy-button",
        onClick: () => makeCopy()
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.shareToSpace.shareWarningLink",
        defaultMessage: "Make a copy"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, createCopyCallout, /*#__PURE__*/_react.default.createElement(_share_mode_control.ShareModeControl, {
    spaces: spaces,
    objectNoun: objectNoun,
    canShareToAllSpaces: canShareToAllSpaces,
    shareOptions: shareOptions,
    onChange: selection => setSelectedSpaceIds(selection),
    enableCreateNewSpaceLink: enableCreateNewSpaceLink,
    enableSpaceAgnosticBehavior: enableSpaceAgnosticBehavior,
    prohibitedSpaces: prohibitedSpaces
  }));
};
exports.ShareToSpaceForm = ShareToSpaceForm;