"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavControlPopover = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _spaces_description = require("./components/spaces_description");
var _spaces_menu = require("./components/spaces_menu");
var _space_avatar = require("../space_avatar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// No need to wrap LazySpaceAvatar in an error boundary, because it is one of the first chunks loaded when opening Kibana.
const LazySpaceAvatar = /*#__PURE__*/(0, _react.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
const popoutContentId = 'headerSpacesMenuContent';
class NavControlPopoverUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "activeSpace$", void 0);
    (0, _defineProperty2.default)(this, "getActiveSpaceButton", () => {
      const {
        activeSpace
      } = this.state;
      if (!activeSpace) {
        return this.getButton(this.getAlignedLoadingSpinner(), 'loading spaces navigation');
      }
      return this.getButton( /*#__PURE__*/_react.default.createElement(_react.Suspense, {
        fallback: this.getAlignedLoadingSpinner()
      }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
        space: activeSpace,
        size: 's'
      })), activeSpace.name);
    });
    (0, _defineProperty2.default)(this, "getButton", (linkIcon, linkTitle) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItemButton, {
        "aria-controls": popoutContentId,
        "aria-expanded": this.state.showSpaceSelector,
        "aria-haspopup": "true",
        "aria-label": _i18n.i18n.translate('xpack.spaces.navControl.popover.spacesNavigationLabel', {
          defaultMessage: 'Spaces navigation'
        }),
        "aria-describedby": "spacesNavDetails",
        "data-test-subj": "spacesNavSelector",
        title: linkTitle,
        onClick: this.toggleSpaceSelector
      }, linkIcon, /*#__PURE__*/_react.default.createElement("p", {
        id: "spacesNavDetails",
        hidden: true
      }, _i18n.i18n.translate('xpack.spaces.navControl.popover.spaceNavigationDetails', {
        defaultMessage: '{space} is the currently selected space. Click this button to open a popover that allows you to select the active space.',
        values: {
          space: linkTitle
        }
      })));
    });
    (0, _defineProperty2.default)(this, "toggleSpaceSelector", () => {
      const isOpening = !this.state.showSpaceSelector;
      if (isOpening) {
        this.loadSpaces();
      }
      this.setState({
        showSpaceSelector: !this.state.showSpaceSelector
      });
    });
    (0, _defineProperty2.default)(this, "closeSpaceSelector", () => {
      this.setState({
        showSpaceSelector: false
      });
    });
    this.state = {
      showSpaceSelector: false,
      loading: false,
      activeSpace: null,
      spaces: []
    };
  }
  componentDidMount() {
    this.activeSpace$ = this.props.spacesManager.onActiveSpaceChange$.subscribe({
      next: activeSpace => {
        this.setState({
          activeSpace
        });
      }
    });
  }
  componentWillUnmount() {
    if (this.activeSpace$) {
      this.activeSpace$.unsubscribe();
    }
  }
  render() {
    const button = this.getActiveSpaceButton();
    const {
      theme
    } = this.props;
    let element;
    if (this.state.loading || this.state.spaces.length < 2) {
      element = /*#__PURE__*/_react.default.createElement(_spaces_description.SpacesDescription, {
        id: popoutContentId,
        isLoading: this.state.loading,
        toggleSpaceSelector: this.toggleSpaceSelector,
        capabilities: this.props.capabilities,
        navigateToApp: this.props.navigateToApp
      });
    } else {
      element = /*#__PURE__*/_react.default.createElement(_spaces_menu.SpacesMenu, {
        id: popoutContentId,
        spaces: this.state.spaces,
        serverBasePath: this.props.serverBasePath,
        toggleSpaceSelector: this.toggleSpaceSelector,
        capabilities: this.props.capabilities,
        navigateToApp: this.props.navigateToApp,
        navigateToUrl: this.props.navigateToUrl,
        activeSpace: this.state.activeSpace
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "spcMenuPopover",
      button: button,
      isOpen: this.state.showSpaceSelector,
      closePopover: this.closeSpaceSelector,
      anchorPosition: this.props.anchorPosition,
      panelPaddingSize: "none",
      repositionOnScroll: true,
      ownFocus: true,
      zIndex: Number(theme.euiTheme.levels.navigation) + 1 // it needs to sit above the collapsible nav menu
    }, element);
  }
  async loadSpaces() {
    const {
      spacesManager
    } = this.props;
    if (this.state.loading) {
      return;
    }
    this.setState({
      loading: true
    });
    const spaces = await spacesManager.getSpaces();
    this.setState({
      spaces,
      loading: false
    });
  }
  getAlignedLoadingSpinner() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      className: "eui-alignMiddle"
    });
  }
}
const NavControlPopover = (0, _eui.withEuiTheme)(NavControlPopoverUI);
exports.NavControlPopover = NavControlPopover;