"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmAlterActiveSpaceModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmAlterActiveSpaceModalUI = props => /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
  onConfirm: props.onConfirm,
  onCancel: props.onCancel,
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.confirmAlterActiveSpaceModal.title",
    defaultMessage: "Confirm update space"
  }),
  defaultFocusedButton: 'confirm',
  cancelButtonText: props.intl.formatMessage({
    id: 'xpack.spaces.management.confirmAlterActiveSpaceModal.cancelButton',
    defaultMessage: 'Cancel'
  }),
  confirmButtonText: props.intl.formatMessage({
    id: 'xpack.spaces.management.confirmAlterActiveSpaceModal.updateSpaceButton',
    defaultMessage: 'Update space'
  })
}, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.spaces.management.confirmAlterActiveSpaceModal.reloadWarningMessage",
  defaultMessage: "You have updated the visible features in this space. Your page will reload after saving."
})));
const ConfirmAlterActiveSpaceModal = (0, _i18nReact.injectI18n)(ConfirmAlterActiveSpaceModalUI);
exports.ConfirmAlterActiveSpaceModal = ConfirmAlterActiveSpaceModal;