"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyStatusSummaryIndicator = void 0;
require("./copy_status_summary_indicator.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _resolve_all_conflicts = require("./resolve_all_conflicts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderIcon = props => {
  const {
    space,
    summarizedCopyResult,
    conflictResolutionInProgress,
    retries,
    onRetriesChange,
    onDestinationMapChange
  } = props;
  const getDataTestSubj = status => `cts-summary-indicator-${status}-${space.id}`;
  if (summarizedCopyResult.processing || conflictResolutionInProgress) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": getDataTestSubj('loading')
    });
  }
  const {
    successful,
    hasUnresolvableErrors,
    hasMissingReferences,
    hasConflicts
  } = summarizedCopyResult;
  if (successful) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: 'checkInCircleFilled',
      color: 'success',
      iconProps: {
        'data-test-subj': getDataTestSubj('success')
      },
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.copyToSpace.copyStatusSummary.successMessage",
        defaultMessage: "Copy to the {space} space was successful.",
        values: {
          space: space.name
        }
      })
    });
  }
  if (hasUnresolvableErrors) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: 'alert',
      color: 'danger',
      iconProps: {
        'data-test-subj': getDataTestSubj('failed')
      },
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.copyToSpace.copyStatusSummary.failedMessage",
        defaultMessage: "Copy to the {space} space failed. Expand this section for details.",
        values: {
          space: space.name
        }
      })
    });
  }
  const missingReferences = hasMissingReferences ? /*#__PURE__*/_react.default.createElement("span", {
    className: "spcCopyToSpace__missingReferencesIcon"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: 'link',
    color: 'warning',
    iconProps: {
      'data-test-subj': getDataTestSubj('missingReferences')
    },
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatusSummary.missingReferencesMessage",
      defaultMessage: "Missing references detected in the {space} space. Expand this section for details.",
      values: {
        space: space.name
      }
    })
  })) : null;
  if (hasConflicts) {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_resolve_all_conflicts.ResolveAllConflicts, {
      summarizedCopyResult: summarizedCopyResult,
      retries: retries,
      onRetriesChange: onRetriesChange,
      onDestinationMapChange: onDestinationMapChange
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: 'alert',
      color: 'warning',
      iconProps: {
        'data-test-subj': getDataTestSubj('conflicts')
      },
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.copyToSpace.copyStatusSummary.conflictsMessage",
        defaultMessage: "Conflicts detected in the {space} space. Expand this section to resolve.",
        values: {
          space: space.name
        }
      })
    }), missingReferences);
  }
  return missingReferences;
};
const CopyStatusSummaryIndicator = props => {
  const {
    summarizedCopyResult
  } = props;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, renderIcon(props), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "#DDD",
    className: "spcCopyToSpace__summaryCountBadge"
  }, summarizedCopyResult.objects.length));
};
exports.CopyStatusSummaryIndicator = CopyStatusSummaryIndicator;