"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabHistory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _components = require("../../../../../components");
var _navigation = require("../../../../../services/navigation");
var _app_context = require("../../../../../app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabHistory = ({
  policy
}) => {
  const {
    lastSuccess,
    lastFailure,
    nextExecutionMillis,
    name,
    repository
  } = policy;
  const {
    history
  } = (0, _app_context.useServices)();
  const renderLastSuccess = () => {
    if (!lastSuccess) {
      return null;
    }
    const {
      time,
      snapshotName
    } = lastSuccess;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.lastSuccessTitle",
      defaultMessage: "Last successful snapshot"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "successDate"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      "data-test-subj": "title"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.lastSuccess.dateLabel",
      defaultMessage: "Date"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textBreakWord",
      "data-test-subj": "value"
    }, /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
      epochMs: time
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "successSnapshot"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      "data-test-subj": "title"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.lastSuccess.snapshotNameLabel",
      defaultMessage: "Snapshot name"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textBreakWord",
      "data-test-subj": "value"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToSnapshot)(repository, snapshotName)), snapshotName))))));
  };
  const renderLastFailure = () => {
    if (!lastFailure) {
      return null;
    }
    const {
      time,
      snapshotName,
      details
    } = lastFailure;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.lastFailureTitle",
      defaultMessage: "Last snapshot failure"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "failureDate"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      "data-test-subj": "title"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.lastFailure.dateLabel",
      defaultMessage: "Date"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textBreakWord",
      "data-test-subj": "value"
    }, /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
      epochMs: time
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "failureSnapshot"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      "data-test-subj": "title"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.lastFailure.snapshotNameLabel",
      defaultMessage: "Snapshot name"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textBreakWord",
      "data-test-subj": "value"
    }, snapshotName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "failureDetails"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      "data-test-subj": "title"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.lastFailure.detailsLabel",
      defaultMessage: "Details"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textBreakWord",
      "data-test-subj": "value"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "m",
      language: "json",
      isCopyable: true,
      "aria-label": _i18n.i18n.translate('xpack.snapshotRestore.policyDetails.lastFailure.detailsAriaLabel', {
        defaultMessage: `Last failure details for policy '{name}'`,
        values: {
          name
        }
      })
    }, JSON.stringify(details, null, 2)))))));
  };
  return lastSuccess || lastFailure ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, renderLastSuccess(), lastSuccess && lastFailure ? /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null) : null, renderLastFailure()) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.noHistoryMessage",
    defaultMessage: "This policy will run on {date} at {time}.",
    values: {
      date: /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
        epochMs: nextExecutionMillis,
        type: "date"
      }),
      time: /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
        epochMs: nextExecutionMillis,
        type: "time"
      })
    }
  })));
};
exports.TabHistory = TabHistory;