"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRepositoryTypeDocUrl = void 0;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRepositoryTypeDocUrl = (docLinks, type) => {
  switch (type) {
    case _common.REPOSITORY_TYPES.fs:
      return docLinks.links.snapshotRestore.registerSharedFileSystem;
    case _common.REPOSITORY_TYPES.url:
      return `${docLinks.links.snapshotRestore.registerUrl}`;
    case _common.REPOSITORY_TYPES.source:
      return `${docLinks.links.snapshotRestore.registerSourceOnly}`;
    case _common.REPOSITORY_TYPES.s3:
      return `${docLinks.links.plugins.s3Repo}`;
    case _common.REPOSITORY_TYPES.hdfs:
      return `${docLinks.links.plugins.hdfsRepo}`;
    case _common.REPOSITORY_TYPES.azure:
      return `${docLinks.links.plugins.azureRepo}`;
    case _common.REPOSITORY_TYPES.gcs:
      return `${docLinks.links.plugins.gcsRepo}`;
    default:
      return `${docLinks.links.snapshotRestore.guide}`;
  }
};
exports.getRepositoryTypeDocUrl = getRepositoryTypeDocUrl;