"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RetentionSettingsUpdateModalProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../app_context");
var _shared_imports = require("../../shared_imports");
var _constants = require("../constants");
var _http = require("../services/http");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RetentionSettingsUpdateModalProvider = ({
  children
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const toastNotifications = (0, _app_context.useToastNotifications)();
  const [retentionSchedule, setRetentionSchedule] = (0, _react.useState)(_constants.DEFAULT_RETENTION_SCHEDULE);
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const [isEditing, setIsEditing] = (0, _react.useState)(false);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const [isAdvancedCronVisible, setIsAdvancedCronVisible] = (0, _react.useState)(false);
  const onSuccessCallback = (0, _react.useRef)(null);
  const [simpleCron, setSimpleCron] = (0, _react.useState)({
    expression: _constants.DEFAULT_RETENTION_SCHEDULE,
    frequency: _constants.DEFAULT_RETENTION_FREQUENCY
  });
  const [fieldToPreferredValueMap, setFieldToPreferredValueMap] = (0, _react.useState)({});
  const [isInvalid, setIsInvalid] = (0, _react.useState)(false);
  const updateRetentionPrompt = (originalRetentionSchedule, onSuccess = () => undefined) => {
    setIsModalOpen(true);
    setIsAdvancedCronVisible(Boolean(originalRetentionSchedule && originalRetentionSchedule !== _constants.DEFAULT_RETENTION_SCHEDULE));
    if (originalRetentionSchedule) {
      setIsEditing(true);
      setRetentionSchedule(originalRetentionSchedule);
    }
    onSuccessCallback.current = onSuccess;
  };
  const closeModal = () => {
    setIsModalOpen(false);
  };
  const updateRetentionSetting = async () => {
    if (!retentionSchedule) {
      setIsInvalid(true);
      return;
    }
    setIsSaving(true);
    setSaveError(null);
    const {
      error
    } = await (0, _http.updateRetentionSchedule)(retentionSchedule);
    setIsSaving(false);
    if (error) {
      setSaveError(error);
    } else {
      closeModal();
      toastNotifications.addSuccess(i18n.translate('xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionSuccessMessage', {
        defaultMessage: 'Retention schedule updated'
      }));
      if (onSuccessCallback.current) {
        onSuccessCallback.current();
      }
    }
  };
  const renderModal = () => {
    if (!isModalOpen) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: closeModal
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, isEditing ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionEditTitle",
      defaultMessage: "Edit retention schedule"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionAddTitle",
      defaultMessage: "Add retention schedule"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, saveError && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionErrorTitle",
        defaultMessage: "Error saving retention schedule"
      }),
      color: "danger",
      iconType: "warning"
    }, saveError.data && saveError.data.message ? /*#__PURE__*/_react.default.createElement("p", null, saveError.data.message) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })), isAdvancedCronVisible ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionScheduleLabel",
        defaultMessage: "Retention schedule"
      }),
      isInvalid: isInvalid,
      error: i18n.translate('xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionScheduleFieldErrorMessage', {
        defaultMessage: 'Retention schedule is required.'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionHelpText",
        defaultMessage: "Use cron expression. {docLink}",
        values: {
          docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks.links.watcher.cronSchedule,
            target: "_blank"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionHelpTextDocLinkText",
            defaultMessage: "Learn more."
          }))
        }
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      defaultValue: retentionSchedule,
      fullWidth: true,
      onChange: e => setRetentionSchedule(e.target.value)
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        setIsAdvancedCronVisible(false);
        setRetentionSchedule(simpleCron.expression);
      },
      "data-test-subj": "showBasicCronLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionBasicLabel",
      defaultMessage: "Create basic interval"
    })))) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.CronEditor, {
      fieldToPreferredValueMap: fieldToPreferredValueMap,
      cronExpression: simpleCron.expression,
      frequency: simpleCron.frequency,
      onChange: ({
        cronExpression: expression,
        frequency,
        fieldToPreferredValueMap: newFieldToPreferredValueMap
      }) => {
        setSimpleCron({
          expression,
          frequency
        });
        setFieldToPreferredValueMap(newFieldToPreferredValueMap);
        setRetentionSchedule(expression);
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        setIsAdvancedCronVisible(true);
      },
      "data-test-subj": "showAdvancedCronLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionAdvancedLabel",
      defaultMessage: "Create cron expression"
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: closeModal
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionCancelButtonLabel",
      defaultMessage: "Cancel"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: updateRetentionSetting,
      fill: true,
      isLoading: isSaving
    }, isEditing ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionEditButtonLabel",
      defaultMessage: "Save changes"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionSaveButtonLabel",
      defaultMessage: "Schedule"
    }))));
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, children(updateRetentionPrompt), renderModal());
};
exports.RetentionSettingsUpdateModalProvider = RetentionSettingsUpdateModalProvider;