"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorMessageStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const errorMessageStrings = {
  fatal: {
    callout: {
      title: () => _i18n.i18n.translate('sharedUXPackages.error_boundary.fatal.prompt.title', {
        defaultMessage: 'Unable to load page'
      }),
      body: () => _i18n.i18n.translate('sharedUXPackages.error_boundary.fatal.prompt.body', {
        defaultMessage: 'Try refreshing the page to resolve the issue.'
      }),
      showDetailsButton: () => _i18n.i18n.translate('sharedUXPackages.error_boundary.fatal.prompt.detailButton', {
        defaultMessage: 'Show details'
      }),
      details: {
        title: () => _i18n.i18n.translate('sharedUXPackages.error_boundary.fatal.prompt.details.title', {
          defaultMessage: 'Error details'
        }),
        componentName: errorComponentName => _i18n.i18n.translate('sharedUXPackages.error_boundary.fatal.prompt.details', {
          defaultMessage: 'The above error occurred in {name}:',
          values: {
            name: errorComponentName
          }
        }),
        closeButton: () => _i18n.i18n.translate('sharedUXPackages.error_boundary.fatal.prompt.details.close', {
          defaultMessage: 'Close'
        }),
        copyToClipboardButton: () => _i18n.i18n.translate('sharedUXPackages.error_boundary.fatal.prompt.details.copyToClipboard', {
          defaultMessage: 'Copy error to clipboard'
        })
      },
      pageReloadButton: () => _i18n.i18n.translate('sharedUXPackages.error_boundary.fatal.prompt.pageReloadButton', {
        defaultMessage: 'Refresh page'
      })
    }
  },
  recoverable: {
    callout: {
      title: () => _i18n.i18n.translate('sharedUXPackages.error_boundary.recoverable.prompt.title', {
        defaultMessage: 'Refresh the page'
      }),
      body: () => _i18n.i18n.translate('sharedUXPackages.error_boundary.recoverable.prompt.body', {
        defaultMessage: 'This should resolve any issues loading the page.'
      }),
      pageReloadButton: () => _i18n.i18n.translate('sharedUXPackages.error_boundary.recoverable.prompt.pageReloadButton', {
        defaultMessage: 'Refresh page'
      })
    }
  }
};
exports.errorMessageStrings = errorMessageStrings;