"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaErrorBoundaryProvider = exports.KibanaErrorBoundaryDepsProvider = void 0;
exports.useErrorBoundary = useErrorBoundary;
var _react = _interopRequireWildcard(require("react"));
var _error_service = require("./error_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const Context = /*#__PURE__*/_react.default.createContext(null);

/**
 * A Context Provider for Jest and Storybooks
 * @internal
 */
const KibanaErrorBoundaryDepsProvider = ({
  children,
  onClickRefresh,
  errorService
}) => /*#__PURE__*/_react.default.createElement(Context.Provider, {
  value: {
    onClickRefresh,
    errorService
  }
}, children);

/**
 * Provider that uses dependencies to give context to the KibanaErrorBoundary component
 * This provider is aware if services were already created from a higher level of the component tree
 * @public
 */
exports.KibanaErrorBoundaryDepsProvider = KibanaErrorBoundaryDepsProvider;
const KibanaErrorBoundaryProvider = ({
  children,
  analytics
}) => {
  const parentContext = (0, _react.useContext)(Context);
  const value = (0, _react.useMemo)(() => {
    // FIXME: analytics dep is optional - know when not to overwrite
    if (parentContext) {
      return parentContext;
    }
    return {
      onClickRefresh: () => window.location.reload(),
      errorService: new _error_service.KibanaErrorService({
        analytics
      })
    };
  }, [parentContext, analytics]);
  return /*#__PURE__*/_react.default.createElement(Context.Provider, {
    value: value
  }, children);
};

/**
 * Utility that provides context
 * @internal
 */
exports.KibanaErrorBoundaryProvider = KibanaErrorBoundaryProvider;
function useErrorBoundary() {
  const context = (0, _react.useContext)(Context);
  if (!context) {
    throw new Error('Kibana Error Boundary Context is missing. Ensure your component or React root is wrapped with Kibana Error Boundary Context.');
  }
  return context;
}