"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reactFatalErrorSchema = exports.REACT_FATAL_ERROR_EVENT_TYPE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
const REACT_FATAL_ERROR_EVENT_TYPE = 'fatal-error-react';

/** @internal */
exports.REACT_FATAL_ERROR_EVENT_TYPE = REACT_FATAL_ERROR_EVENT_TYPE;
/** @internal */
const reactFatalErrorSchema = {
  component_name: {
    type: 'keyword',
    _meta: {
      description: 'Name of react component that threw an error',
      optional: false
    }
  },
  error_message: {
    type: 'keyword',
    _meta: {
      description: 'Message from the error',
      optional: false
    }
  }
};
exports.reactFatalErrorSchema = reactFatalErrorSchema;