"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndices = fetchIndices;
var _is_not_nullish = require("../../../common/utils/is_not_nullish");
var _index_utils = require("../../utils/index_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchIndices(client, from, size, searchQuery) {
  const indexPattern = searchQuery ? `*${searchQuery}*` : '*';
  const indexMatches = await client.indices.get({
    expand_wildcards: ['open'],
    // for better performance only compute settings of indices but not mappings
    features: ['aliases', 'settings'],
    index: indexPattern
  });
  const indexNames = Object.keys(indexMatches).filter(indexName => indexMatches[indexName] && !(0, _index_utils.isHidden)(indexMatches[indexName]) && !(0, _index_utils.isClosed)(indexMatches[indexName]));
  const indexNameSlice = indexNames.slice(from, from + size).filter(_is_not_nullish.isNotNullish);
  if (indexNameSlice.length === 0) {
    return [];
  }
  const indexCounts = await fetchIndexCounts(client, indexNameSlice);
  return indexNameSlice.map(name => {
    var _indexCounts$name$tot, _indexCounts$name, _indexCounts$name$tot2, _indexCounts$name$tot3;
    return {
      name,
      count: (_indexCounts$name$tot = (_indexCounts$name = indexCounts[name]) === null || _indexCounts$name === void 0 ? void 0 : (_indexCounts$name$tot2 = _indexCounts$name.total) === null || _indexCounts$name$tot2 === void 0 ? void 0 : (_indexCounts$name$tot3 = _indexCounts$name$tot2.docs) === null || _indexCounts$name$tot3 === void 0 ? void 0 : _indexCounts$name$tot3.count) !== null && _indexCounts$name$tot !== void 0 ? _indexCounts$name$tot : 0
    };
  });
}
const fetchIndexCounts = async (client, indicesNames) => {
  if (indicesNames.length === 0) {
    return {};
  }
  const indexCounts = {};
  // batch calls in batches of 100 to prevent loading too much onto ES
  for (let i = 0; i < indicesNames.length; i += 100) {
    const stats = await client.indices.stats({
      index: indicesNames.slice(i, i + 100),
      metric: ['docs']
    });
    Object.assign(indexCounts, stats.indices);
  }
  return indexCounts;
};