"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowErrorToast = void 0;
var _get_error_message = require("../../utils/get_error_message");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useShowErrorToast = () => {
  const {
    notifications
  } = (0, _use_kibana.useKibanaServices)();
  return (error, errorTitle) => notifications.toasts.addError(new Error((0, _get_error_message.getErrorMessage)(error)), {
    title: errorTitle || (0, _get_error_message.getErrorMessage)(error)
  });
};
exports.useShowErrorToast = useShowErrorToast;