"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConnectorTypes = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useConnectorTypes = () => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['fetchConnectorTypes'],
    queryFn: () => http.fetch('/internal/serverless_search/connector_types')
  });
};
exports.useConnectorTypes = useConnectorTypes;