"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditName = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _i18n_string = require("../../../../common/i18n_string");
var _use_kibana = require("../../hooks/use_kibana");
var _use_connector = require("../../hooks/api/use_connector");
var _use_error_toast = require("../../hooks/use_error_toast");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditName = ({
  connector
}) => {
  const [isEditing, setIsEditing] = (0, _react2.useState)(false);
  const [newName, setNewName] = (0, _react2.useState)(connector.name || _i18n_string.CONNECTOR_LABEL);
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const showErrorToast = (0, _use_error_toast.useShowErrorToast)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    queryKey
  } = (0, _use_connector.useConnector)(connector.id);
  (0, _react2.useEffect)(() => setNewName(connector.name), [connector.name]);
  const {
    isLoading,
    mutate
  } = (0, _reactQuery.useMutation)({
    mutationFn: async inputName => {
      const body = {
        name: inputName
      };
      await http.post(`/internal/serverless_search/connectors/${connector.id}/name`, {
        body: JSON.stringify(body)
      });
      return inputName;
    },
    onError: error => showErrorToast(error, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.connectorNameError', {
      defaultMessage: 'Error updating name'
    })),
    onSuccess: successData => {
      queryClient.setQueryData(queryKey, {
        connector: {
          ...connector,
          service_type: successData
        }
      });
      queryClient.invalidateQueries(queryKey);
      setIsEditing(false);
    }
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, !isEditing ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react2.default.createElement("h1", null, connector.name || _i18n_string.CONNECTOR_LABEL))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
              justify-content: center;
            `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "serverlessSearchEditNameButton",
    color: "text",
    iconType: "pencil",
    "aria-label": _i18n.i18n.translate('xpack.serverlessSearch.connectors.editNameLabel', {
      defaultMessage: 'Edit connector name'
    }),
    onClick: () => setIsEditing(true)
  }))) : /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormLabel, null, _i18n.i18n.translate('xpack.serverlessSearch.connectors.nameLabel', {
    defaultMessage: 'Name'
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "serverlessSearchEditNameFieldText",
    onChange: event => setNewName(event.target.value),
    value: newName
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
                justify-content: center;
              `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchEditNameButton",
    color: "primary",
    fill: true,
    type: "submit",
    onClick: () => mutate(newName),
    size: "s",
    isLoading: isLoading
  }, _i18n_string.SAVE_LABEL)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
                justify-content: center;
              `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchEditNameButton",
    size: "s",
    isLoading: isLoading,
    onClick: () => {
      setNewName(connector.name);
      setIsEditing(false);
    }
  }, _i18n_string.CANCEL_LABEL)))));
};
exports.EditName = EditName;