"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorIndexnamePanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _react = _interopRequireWildcard(require("react"));
var _validate_index_name = require("../../../../utils/validate_index_name");
var _i18n_string = require("../../../../../common/i18n_string");
var _use_connector = require("../../../hooks/api/use_connector");
var _use_kibana = require("../../../hooks/use_kibana");
var _connector_index_name_form = require("./connector_index_name_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorIndexnamePanel = ({
  connector
}) => {
  const {
    http,
    notifications
  } = (0, _use_kibana.useKibanaServices)();
  const {
    data,
    error,
    isLoading,
    isSuccess,
    mutate,
    reset
  } = (0, _reactQuery.useMutation)({
    mutationFn: async inputName => {
      if (inputName && inputName !== connector.index_name) {
        const body = {
          index_name: inputName
        };
        await http.post(`/internal/serverless_search/connectors/${connector.id}/index_name`, {
          body: JSON.stringify(body)
        });
      }
      return inputName;
    }
  });
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    queryKey
  } = (0, _use_connector.useConnector)(connector.id);
  (0, _react.useEffect)(() => {
    if (isSuccess) {
      queryClient.setQueryData(queryKey, {
        connector: {
          ...connector,
          index_name: data
        }
      });
      queryClient.invalidateQueries(queryKey);
      reset();
    }
  }, [data, isSuccess, connector, queryClient, queryKey, reset]);
  (0, _react.useEffect)(() => {
    if (error) {
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.connectorIndexNameError', {
          defaultMessage: 'Error updating index name'
        })
      });
    }
  }, [error, notifications]);
  const [newIndexName, setNewIndexName] = (0, _react.useState)(connector.index_name || '');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_connector_index_name_form.ConnectorIndexNameForm, {
    isDisabled: isLoading,
    indexName: newIndexName,
    onChange: name => setNewIndexName(name)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchConnectorIndexnamePanelButton",
    color: "primary",
    disabled: !(0, _validate_index_name.isValidIndexName)(newIndexName),
    fill: true,
    isLoading: isLoading,
    onClick: () => mutate(newIndexName)
  }, _i18n_string.UPDATE_LABEL)))));
};
exports.ConnectorIndexnamePanel = ConnectorIndexnamePanel;