"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfiguration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _searchConnectors = require("@kbn/search-connectors");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18n_string = require("../../../../../common/i18n_string");
var _connector_link = require("./connector_link");
var _connector_config_fields = require("./connector_config_fields");
var _connector_index_name = require("./connector_index_name");
var _connector_config_panels = require("./connector_config_panels");
var _connector_overview = require("./connector_overview");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorConfiguration = ({
  connector
}) => {
  const [currentStep, setCurrentStep] = (0, _react.useState)('link');
  (0, _react.useEffect)(() => {
    const step = connector.status === _searchConnectors.ConnectorStatus.CREATED ? 'link' : connector.status === _searchConnectors.ConnectorStatus.NEEDS_CONFIGURATION ? 'configure' : connector.status === _searchConnectors.ConnectorStatus.CONFIGURED ? 'connect' : 'connected';
    setCurrentStep(step);
  }, [connector.status, setCurrentStep]);
  const steps = [{
    title: _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.linkToElasticTitle', {
      defaultMessage: 'Link to Elasticsearch'
    }),
    status: currentStep === 'link' ? 'current' : connector.status === _searchConnectors.ConnectorStatus.CREATED ? 'incomplete' : 'complete',
    onClick: () => setCurrentStep('link'),
    size: 's'
  }, {
    title: _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.configureTitle', {
      defaultMessage: 'Configure'
    }),
    status: currentStep === 'configure' ? 'current' : connector.status === _searchConnectors.ConnectorStatus.CONFIGURED || connector.status === _searchConnectors.ConnectorStatus.CONNECTED ? 'complete' : 'incomplete',
    onClick: () => setCurrentStep('configure'),
    size: 's'
  }, {
    title: _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.connectTitle', {
      defaultMessage: 'Connect Index'
    }),
    status: currentStep === 'connect' ? 'current' : connector.status === _searchConnectors.ConnectorStatus.CONNECTED && connector.index_name ? 'complete' : 'incomplete',
    onClick: () => setCurrentStep('connect'),
    size: 's'
  }];
  const tabs = [{
    content: /*#__PURE__*/_react.default.createElement(_connector_overview.ConnectorOverview, {
      connector: connector
    }),
    id: 'overview',
    name: _i18n_string.OVERVIEW_LABEL
  }, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_connector_config_panels.ConnectorConfigurationPanels, {
      connector: connector
    })),
    id: 'configuration',
    name: _i18n_string.CONFIGURATION_LABEL
  }];
  return currentStep === 'connected' ? /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    size: "s",
    steps: steps
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, currentStep === 'link' && /*#__PURE__*/_react.default.createElement(_connector_link.ConnectorLinkElasticsearch, {
    connectorId: connector.id,
    serviceType: connector.service_type || '',
    status: connector.status
  }), currentStep === 'configure' && /*#__PURE__*/_react.default.createElement(_connector_config_fields.ConnectorConfigFields, {
    connector: connector
  }), currentStep === 'connect' && /*#__PURE__*/_react.default.createElement(_connector_index_name.ConnectorIndexName, {
    connector: connector
  })));
};
exports.ConnectorConfiguration = ConnectorConfiguration;