"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateApiKeyFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18n_string = require("../../../../common/i18n_string");
var _api = require("../../../utils/api");
var _basic_setup_form = require("./basic_setup_form");
var _metadata_form = require("./metadata_form");
var _security_privileges_form = require("./security_privileges_form");
var _use_create_api_key = require("../../hooks/api/use_create_api_key");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ROLE_DESCRIPTORS = `{
  "serverless_search": {
    "indices": [{
      "names": ["*"],
      "privileges": [
        "all"
      ]
    }]
  }
}`;
const DEFAULT_METADATA = `{
  "application": "myapp"
}`;
const parseCreateError = error => {
  if (!error) return undefined;
  if ((0, _api.isApiError)(error)) {
    return error.body.message;
  }
  if (error instanceof Error) {
    return error.message;
  }
  return JSON.stringify(error);
};
const CreateApiKeyFlyout = ({
  onClose,
  username,
  setApiKey
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [name, setName] = (0, _react.useState)('');
  const [expires, setExpires] = (0, _react.useState)(_basic_setup_form.DEFAULT_EXPIRES_VALUE);
  const [roleDescriptors, setRoleDescriptors] = (0, _react.useState)(DEFAULT_ROLE_DESCRIPTORS);
  const [roleDescriptorsError, setRoleDescriptorsError] = (0, _react.useState)(undefined);
  const [metadata, setMetadata] = (0, _react.useState)(DEFAULT_METADATA);
  const [metadataError, setMetadataError] = (0, _react.useState)(undefined);
  const [privilegesEnabled, setPrivilegesEnabled] = (0, _react.useState)(false);
  const [privilegesOpen, setPrivilegesOpen] = (0, _react.useState)('closed');
  const [metadataEnabled, setMetadataEnabled] = (0, _react.useState)(false);
  const [metadataOpen, setMetadataOpen] = (0, _react.useState)('closed');
  const togglePrivileges = e => {
    const enabled = e.target.checked;
    setPrivilegesEnabled(enabled);
    setPrivilegesOpen(enabled ? 'open' : 'closed');
    // Reset role descriptors to default
    if (enabled) setRoleDescriptors(DEFAULT_ROLE_DESCRIPTORS);
  };
  const toggleMetadata = e => {
    const enabled = e.target.checked;
    setMetadataEnabled(enabled);
    setMetadataOpen(enabled ? 'open' : 'closed');
    // Reset metadata to default
    if (enabled) setMetadata(DEFAULT_METADATA);
  };
  const onCreateClick = () => {
    let parsedRoleDescriptors;
    if (privilegesEnabled) {
      try {
        parsedRoleDescriptors = roleDescriptors.length > 0 ? JSON.parse(roleDescriptors) : undefined;
      } catch (e) {
        setRoleDescriptorsError(_i18n_string.INVALID_JSON_ERROR);
        return;
      }
    }
    if (roleDescriptorsError) setRoleDescriptorsError(undefined);
    let parsedMetadata;
    if (metadataEnabled) {
      try {
        parsedMetadata = metadata.length > 0 ? JSON.parse(metadata) : undefined;
      } catch (e) {
        setMetadataError(_i18n_string.INVALID_JSON_ERROR);
        return;
      }
    }
    if (metadataError) setMetadataError(undefined);
    const expiration = expires !== null ? `${expires}d` : undefined;
    mutate({
      expiration,
      metadata: parsedMetadata,
      name,
      role_descriptors: parsedRoleDescriptors
    });
  };
  const {
    data,
    isLoading,
    isError,
    isSuccess,
    error,
    mutate
  } = (0, _use_create_api_key.useCreateApiKey)();
  (0, _react.useEffect)(() => {
    if (isSuccess) {
      setApiKey(data);
      onClose();
    }
  });
  const createError = parseCreateError(error);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    css: (0, _react2.css)`
        max-width: calc(${euiTheme.size.xxxxl} * 10);
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.flyoutTitle', {
    defaultMessage: 'Create an API key'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, isError && createError && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.serverlessSearch.apiKey.flyout.errorTitle', {
      defaultMessage: 'Error creating API key'
    }),
    "data-test-subj": "create-api-key-error-callout"
  }, createError), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "apiKey.setup",
    paddingSize: "l",
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "gear"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.setup.title', {
      defaultMessage: 'Setup'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.setup.description', {
      defaultMessage: 'Basic configuration details to create your API key.'
    })))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, _i18n_string.REQUIRED_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_basic_setup_form.BasicSetupForm, {
    isLoading: isLoading,
    name: name,
    user: username,
    expires: expires,
    onChangeName: newName => setName(newName),
    onChangeExpires: newExpires => setExpires(newExpires)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "apiKey.privileges",
    paddingSize: "l",
    buttonContent: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        paddingRight: euiTheme.size.s
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "lock"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.privileges.title', {
      defaultMessage: 'Security Privileges'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.privileges.description', {
      defaultMessage: 'Control access to specific Elasticsearch APIs and resources using predefined roles or custom privileges per API key.'
    })))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: privilegesEnabled ? _i18n_string.ENABLED_LABEL : _i18n_string.DISABLED_LABEL,
      checked: privilegesEnabled,
      onChange: togglePrivileges,
      "data-test-subj": "create-api-role-descriptors-switch"
    }),
    forceState: privilegesOpen,
    onToggle: isOpen => {
      if (privilegesEnabled) {
        setPrivilegesOpen(isOpen ? 'open' : 'closed');
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_security_privileges_form.SecurityPrivilegesForm, {
    roleDescriptors: roleDescriptors,
    onChangeRoleDescriptors: setRoleDescriptors,
    error: roleDescriptorsError
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "apiKey.metadata",
    paddingSize: "l",
    buttonContent: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        paddingRight: euiTheme.size.s
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visVega"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.metadata.title', {
      defaultMessage: 'Metadata'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.metadata.description', {
      defaultMessage: 'Use configurable key-value pairs to add information about the API key or customize Elasticsearch resource access.'
    })))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: metadataEnabled ? _i18n_string.ENABLED_LABEL : _i18n_string.DISABLED_LABEL,
      checked: metadataEnabled,
      onChange: toggleMetadata,
      "data-test-subj": "create-api-metadata-switch"
    }),
    forceState: metadataOpen,
    onToggle: isOpen => {
      if (metadataEnabled) {
        setMetadataOpen(isOpen ? 'open' : 'closed');
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_metadata_form.MetadataForm, {
    metadata: metadata,
    onChangeMetadata: setMetadata,
    error: metadataError
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isDisabled: isLoading,
    onClick: onClose,
    "data-test-subj": "create-api-key-cancel"
  }, _i18n_string.CANCEL_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: !name,
    isLoading: isLoading,
    onClick: onCreateClick,
    "data-test-subj": "create-api-key-submit"
  }, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.flyOutCreateLabel', {
    defaultMessage: 'Create API Key'
  }))))))));
};
exports.CreateApiKeyFlyout = CreateApiKeyFlyout;