"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessObservabilityPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _managementCardsNavigation = require("@kbn/management-cards-navigation");
var _types = require("@kbn/management-cards-navigation/src/types");
var _side_navigation = require("./components/side_navigation");
var _overview_registration = require("./logs_signal/overview_registration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServerlessObservabilityPlugin {
  setup(_core, setupDeps) {
    setupDeps.observability.dashboard.register((0, _overview_registration.createObservabilityDashboardRegistration)({
      search: _core.getStartServices().then(([_coreStart, startDeps]) => startDeps.data.search.search)
    }));
    return {};
  }
  start(core, setupDeps) {
    const {
      observabilityShared,
      serverless,
      management,
      cloud
    } = setupDeps;
    observabilityShared.setIsSidebarEnabled(false);
    serverless.setProjectHome('/app/observability/landing');
    serverless.setSideNavComponent((0, _side_navigation.getObservabilitySideNavComponent)(core, {
      serverless,
      cloud
    }));
    management.setIsSidebarEnabled(false);
    management.setupCardsNavigation({
      enabled: true,
      hideLinksTo: [_managementCardsNavigation.appIds.RULES],
      extendCardNavDefinitions: {
        aiAssistantManagementObservability: {
          category: _types.appCategories.OTHER,
          title: _i18n.i18n.translate('xpack.serverlessObservability.aiAssistantManagementTitle', {
            defaultMessage: 'AI assistant for Observability settings'
          }),
          description: _i18n.i18n.translate('xpack.serverlessObservability.aiAssistantManagementDescription', {
            defaultMessage: 'Manage your AI assistant for Observability settings.'
          }),
          icon: 'sparkles'
        }
      }
    });
    return {};
  }
  stop() {}
}
exports.ServerlessObservabilityPlugin = ServerlessObservabilityPlugin;