"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexListFromIndexString = exports.getIndexListFromEsqlQuery = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * parses ES|QL query and returns array of indices
 */
const getIndexListFromEsqlQuery = query => {
  const indexString = (0, _esQuery.getIndexPatternFromESQLQuery)(query);
  return getIndexListFromIndexString(indexString);
};

/**
 * transforms sting of indices, separated by commas to array
 * index*, index2* => [index*, index2*]
 */
exports.getIndexListFromEsqlQuery = getIndexListFromEsqlQuery;
const getIndexListFromIndexString = indexString => {
  if (!indexString) {
    return [];
  }
  return indexString.split(',').map(index => index.trim());
};
exports.getIndexListFromIndexString = getIndexListFromIndexString;