"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listSchema = exports.listArraySchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _underscore_version = require("../../common/underscore_version");
var _deserializer = require("../../common/deserializer");
var _meta = require("../../common/meta");
var _serializer = require("../../common/serializer");
var _created_at = require("../../common/created_at");
var _timestamp = require("../../common/timestamp");
var _created_by = require("../../common/created_by");
var _description = require("../../common/description");
var _id = require("../../common/id");
var _immutable = require("../../common/immutable");
var _name = require("../../common/name");
var _tie_breaker_id = require("../../common/tie_breaker_id");
var _type = require("../../common/type");
var _updated_at = require("../../common/updated_at");
var _updated_by = require("../../common/updated_by");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const listSchema = t.exact(t.type({
  _version: _underscore_version._versionOrUndefined,
  '@timestamp': _timestamp.timestampOrUndefined,
  created_at: _created_at.created_at,
  created_by: _created_by.created_by,
  description: _description.description,
  deserializer: _deserializer.deserializerOrUndefined,
  id: _id.id,
  immutable: _immutable.immutable,
  meta: _meta.metaOrUndefined,
  name: _name.name,
  serializer: _serializer.serializerOrUndefined,
  tie_breaker_id: _tie_breaker_id.tie_breaker_id,
  type: _type.type,
  updated_at: _updated_at.updated_at,
  updated_by: _updated_by.updated_by,
  version: _securitysolutionIoTsTypes.version
}));
exports.listSchema = listSchema;
const listArraySchema = t.array(listSchema);
exports.listArraySchema = listArraySchema;