"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setEndpointPackagePolicyServerlessFlag = setEndpointPackagePolicyServerlessFlag;
var _common = require("@kbn/fleet-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// set all endpoint policies serverless flag to true
// required so that endpoint will write heartbeats
async function setEndpointPackagePolicyServerlessFlag(soClient, esClient, packagePolicyService) {
  const perPage = _common.SO_SEARCH_LIMIT;
  let page = 1;
  let endpointPackagesResult;
  while (page === 1 || ((_endpointPackagesResu = endpointPackagesResult) === null || _endpointPackagesResu === void 0 ? void 0 : _endpointPackagesResu.total) === perPage) {
    var _endpointPackagesResu;
    endpointPackagesResult = await getEndpointPackagePolicyBatch(soClient, packagePolicyService, page, perPage);
    await processBatch(endpointPackagesResult, soClient, esClient, packagePolicyService);
    page++;
  }
}
function getEndpointPackagePolicyBatch(soClient, packagePolicyService, page, perPage) {
  return packagePolicyService.list(soClient, {
    page,
    perPage,
    kuery: `${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${_common.FLEET_ENDPOINT_PACKAGE}`
  });
}
async function processBatch(endpointPackagesResult, soClient, esClient, packagePolicyService) {
  if (!endpointPackagesResult.total) {
    return;
  }
  const updatedEndpointPackages = endpointPackagesResult.items.filter(endpointPackage => {
    var _endpointPackage$inpu;
    return !((_endpointPackage$inpu = endpointPackage === null || endpointPackage === void 0 ? void 0 : endpointPackage.inputs.every(input => {
      var _input$config$policy$, _input$config, _input$config$policy, _input$config$policy$2, _input$config$policy$3;
      return (_input$config$policy$ = (_input$config = input.config) === null || _input$config === void 0 ? void 0 : (_input$config$policy = _input$config.policy) === null || _input$config$policy === void 0 ? void 0 : (_input$config$policy$2 = _input$config$policy.value) === null || _input$config$policy$2 === void 0 ? void 0 : (_input$config$policy$3 = _input$config$policy$2.meta) === null || _input$config$policy$3 === void 0 ? void 0 : _input$config$policy$3.serverless) !== null && _input$config$policy$ !== void 0 ? _input$config$policy$ : false;
    })) !== null && _endpointPackage$inpu !== void 0 ? _endpointPackage$inpu : false);
  }).map(endpointPackage => ({
    ...endpointPackage,
    inputs: endpointPackage.inputs.map(input => {
      const config = (input === null || input === void 0 ? void 0 : input.config) || {};
      const policy = config.policy || {};
      const policyValue = (policy === null || policy === void 0 ? void 0 : policy.value) || {};
      const meta = (policyValue === null || policyValue === void 0 ? void 0 : policyValue.meta) || {};
      return {
        ...input,
        config: {
          ...config,
          policy: {
            ...policy,
            value: {
              ...policyValue,
              meta: {
                ...meta,
                serverless: true
              }
            }
          }
        }
      };
    })
  }));
  if (updatedEndpointPackages.length === 0) {
    return;
  }
  await packagePolicyService.bulkUpdate(soClient, esClient, updatedEndpointPackages);
}