"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.endpointMeteringService = exports.EndpointMeteringService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("@kbn/security-solution-plugin/common/endpoint/constants");
var _product = require("../../../common/product");
var _metering = require("../constants/metering");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EndpointMeteringService {
  constructor() {
    (0, _defineProperty2.default)(this, "type", void 0);
    (0, _defineProperty2.default)(this, "tier", void 0);
    (0, _defineProperty2.default)(this, "getUsageRecords", async ({
      taskId,
      cloudSetup,
      esClient,
      abortController,
      lastSuccessfulReport,
      config,
      logger
    }) => {
      var _heartbeatsResponse$h;
      this.setType(config);
      if (!this.type) {
        return [];
      }
      this.setTier(config);
      const heartbeatsResponse = await this.getHeartbeatsSince(esClient, abortController, lastSuccessfulReport);
      if (!(heartbeatsResponse !== null && heartbeatsResponse !== void 0 && (_heartbeatsResponse$h = heartbeatsResponse.hits) !== null && _heartbeatsResponse$h !== void 0 && _heartbeatsResponse$h.hits)) {
        return [];
      }
      return heartbeatsResponse.hits.hits.reduce((acc, {
        _source
      }) => {
        var _cloudSetup$serverles;
        if (!_source) {
          return acc;
        }
        const {
          agent,
          event
        } = _source;
        const record = this.buildMeteringRecord({
          logger,
          agentId: agent.id,
          timestampStr: event.ingested,
          taskId,
          projectId: cloudSetup === null || cloudSetup === void 0 ? void 0 : (_cloudSetup$serverles = cloudSetup.serverless) === null || _cloudSetup$serverles === void 0 ? void 0 : _cloudSetup$serverles.projectId
        });
        return [...acc, record];
      }, []);
    });
  }
  async getHeartbeatsSince(esClient, abortController, since) {
    const thresholdDate = new Date(Date.now() - _metering.METERING_TASK.THRESHOLD_MINUTES * 60 * 1000);
    const searchFrom = since && since > thresholdDate ? since : thresholdDate;
    return esClient.search({
      index: _constants.ENDPOINT_HEARTBEAT_INDEX,
      sort: 'event.ingested',
      query: {
        range: {
          'event.ingested': {
            gt: searchFrom.toISOString()
          }
        }
      }
    }, {
      signal: abortController.signal,
      ignore: [404]
    });
  }
  buildMeteringRecord({
    logger,
    agentId,
    timestampStr,
    taskId,
    projectId
  }) {
    const timestamp = new Date(timestampStr);
    timestamp.setMinutes(0);
    timestamp.setSeconds(0);
    timestamp.setMilliseconds(0);
    const usageRecord = {
      // keep endpoint instead of this.type as id prefix so
      // we don't double count in the event of add-on changes
      id: `endpoint-${agentId}-${timestamp.toISOString()}`,
      usage_timestamp: timestampStr,
      creation_timestamp: timestampStr,
      usage: {
        // type postfix is used to determine the PLI to bill
        type: `${_metering.METERING_TASK.USAGE_TYPE_PREFIX}${this.type}`,
        period_seconds: _metering.METERING_TASK.SAMPLE_PERIOD_SECONDS,
        quantity: 1
      },
      source: {
        id: taskId,
        instance_group_id: projectId || _metering.METERING_TASK.MISSING_PROJECT_ID,
        metadata: {
          tier: this.tier
        }
      }
    };
    if (!projectId) {
      logger.error(`project id missing for record: ${JSON.stringify(usageRecord)}`);
    }
    return usageRecord;
  }
  setType(config) {
    if (this.type) {
      return;
    }
    let hasCloudAddOn = false;
    let hasEndpointAddOn = false;
    config.productTypes.forEach(productType => {
      if (productType.product_line === _product.ProductLine.cloud) {
        hasCloudAddOn = true;
      }
      if (productType.product_line === _product.ProductLine.endpoint) {
        hasEndpointAddOn = true;
      }
    });
    if (hasEndpointAddOn) {
      this.type = _product.ProductLine.endpoint;
      return;
    }
    if (hasCloudAddOn) {
      this.type = `${_product.ProductLine.cloud}_${_product.ProductLine.endpoint}`;
    }
  }
  setTier(config) {
    if (this.tier) {
      return;
    }
    const product = config.productTypes.find(productType =>
    // tiers are always matching so either is fine
    productType.product_line === _product.ProductLine.endpoint || productType.product_line === _product.ProductLine.cloud);
    // default essentials is safe since we only reach tier if add-on exists
    this.tier = (product === null || product === void 0 ? void 0 : product.product_tier) || _product.ProductTier.essentials;
  }
}
exports.EndpointMeteringService = EndpointMeteringService;
const endpointMeteringService = new EndpointMeteringService();
exports.endpointMeteringService = endpointMeteringService;