"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usageReportingService = exports.UsageReportingService = void 0;
var _nodeFetch = _interopRequireDefault(require("node-fetch"));
var _https = _interopRequireDefault(require("https"));
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO remove once we have the CA available
const agent = new _https.default.Agent({
  rejectUnauthorized: false
});
class UsageReportingService {
  async reportUsage(records) {
    return (0, _nodeFetch.default)(_constants.USAGE_SERVICE_USAGE_URL, {
      method: 'post',
      body: JSON.stringify(records),
      headers: {
        'Content-Type': 'application/json'
      },
      agent
    });
  }
}
exports.UsageReportingService = UsageReportingService;
const usageReportingService = new UsageReportingService();
exports.usageReportingService = usageReportingService;