"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityAppFeaturesConfigurator = void 0;
var _config = require("@kbn/security-solution-features/config");
var _keys = require("@kbn/security-solution-features/keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSecurityAppFeaturesConfigurator = (enabledAppFeatureKeys, _) => () => {
  return (0, _config.createEnabledAppFeaturesConfigMap)(securityAppFeaturesConfig, enabledAppFeatureKeys);
};

/**
 * Maps the AppFeatures keys to Kibana privileges that will be merged
 * into the base privileges config for the Security app.
 *
 * Privileges can be added in different ways:
 * - `privileges`: the privileges that will be added directly into the main Security feature.
 * - `subFeatureIds`: the ids of the sub-features that will be added into the Security subFeatures entry.
 * - `subFeaturesPrivileges`: the privileges that will be added into the existing Security subFeature with the privilege `id` specified.
 */
exports.getSecurityAppFeaturesConfigurator = getSecurityAppFeaturesConfigurator;
const securityAppFeaturesConfig = {
  ..._config.securityDefaultAppFeaturesConfig,
  [_keys.AppFeatureSecurityKey.endpointExceptions]: {
    subFeatureIds: [_keys.SecuritySubFeatureId.endpointExceptions]
  }
};