"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySolutionServerlessPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _get_started = require("./get_started");
var _dashboards_landing_callout = require("./components/dashboards_landing_callout");
var _upselling = require("./upselling");
var _create_services = require("./common/services/create_services");
var _navigation = require("./navigation");
var _routes = require("./pages/routes");
var _experimental_features = require("../common/experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SecuritySolutionServerlessPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.experimentalFeatures = {};
  }
  setup(core, setupDeps) {
    const {
      securitySolution
    } = setupDeps;
    this.experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental, securitySolution.experimentalFeatures).features;
    (0, _navigation.setupNavigation)(core, setupDeps);
    return {};
  }
  start(core, startDeps) {
    const {
      securitySolution
    } = startDeps;
    const {
      productTypes
    } = this.config;
    const services = (0, _create_services.createServices)(core, startDeps, this.experimentalFeatures);
    (0, _upselling.registerUpsellings)(securitySolution.getUpselling(), productTypes, services);
    securitySolution.setComponents({
      GetStarted: (0, _get_started.getSecurityGetStartedComponent)(services, productTypes),
      DashboardsLandingCallout: (0, _dashboards_landing_callout.getDashboardsLandingCallout)(services)
    });
    (0, _navigation.startNavigation)(services);
    (0, _routes.setRoutes)(services);
    return {};
  }
  stop() {}
}
exports.SecuritySolutionServerlessPlugin = SecuritySolutionServerlessPlugin;