"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MachineLearningRoute = void 0;
var _react = _interopRequireDefault(require("react"));
var _landing_links = require("@kbn/security-solution-navigation/landing_links");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _eui = require("@elastic/eui");
var _public = require("@kbn/usage-collection-plugin/public");
var _use_nav_links = require("../common/hooks/use_nav_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MachineLearningRoute = () => {
  const link = (0, _use_nav_links.useNavLink)(_securitySolutionNavigation.SecurityPageName.mlLanding);
  const {
    links = [],
    categories = [],
    title
  } = link !== null && link !== void 0 ? link : {};
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    restrictWidth: false,
    contentBorder: false,
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
    viewId: _securitySolutionNavigation.SecurityPageName.mlLanding
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: title
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_landing_links.LandingLinksIconsCategories, {
    links: links,
    categories: categories
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.MachineLearningRoute = MachineLearningRoute;
var _default = MachineLearningRoute;
exports.default = _default;