"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSideNavItems = exports.useFormattedSideNavItems = void 0;
var _react = require("react");
var _links = require("@kbn/security-solution-navigation/links");
var _securitySolutionSideNav = require("@kbn/security-solution-side-nav");
var _use_nav_links = require("../../common/hooks/use_nav_links");
var _util = require("../links/util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Formats generic navigation links into the shape expected by the `SolutionSideNav`
 */
const formatLink = (navLink, getLinkProps) => {
  var _navLink$links, _navLink$categories;
  const items = (_navLink$links = navLink.links) === null || _navLink$links === void 0 ? void 0 : _navLink$links.reduce((acc, current) => {
    if (!current.disabled) {
      acc.push({
        id: current.id,
        label: current.title,
        iconType: current.sideNavIcon,
        isBeta: current.isBeta,
        betaOptions: current.betaOptions,
        ...getLinkProps(current)
      });
    }
    return acc;
  }, []);
  return {
    id: navLink.id,
    label: navLink.title,
    iconType: navLink.sideNavIcon,
    position: (0, _util.isBottomNavItemId)(navLink.id) ? _securitySolutionSideNav.SolutionSideNavItemPosition.bottom : _securitySolutionSideNav.SolutionSideNavItemPosition.top,
    ...getLinkProps(navLink),
    ...(((_navLink$categories = navLink.categories) === null || _navLink$categories === void 0 ? void 0 : _navLink$categories.length) && {
      categories: navLink.categories
    }),
    ...(items && {
      items
    })
  };
};

/**
 * Returns all the formatted SideNavItems, including external links
 */
const useSideNavItems = () => {
  const navLinks = (0, _use_nav_links.useNavLinks)();
  return useFormattedSideNavItems(navLinks);
};

/**
 * Returns all the formatted SideNavItems, including external links
 */
exports.useSideNavItems = useSideNavItems;
const useFormattedSideNavItems = navLinks => {
  const getKibanaLinkProps = (0, _links.useGetLinkProps)();
  const getLinkProps = (0, _react.useCallback)(link => {
    if (link.externalUrl) {
      return {
        href: link.externalUrl,
        openInNewTab: true
      };
    } else {
      return getKibanaLinkProps({
        id: link.id
      });
    }
  }, [getKibanaLinkProps]);
  return (0, _react.useMemo)(() => navLinks.reduce((items, navLink) => {
    if (!navLink.disabled) {
      items.push(formatLink(navLink, getLinkProps));
    }
    return items;
  }, []), [getLinkProps, navLinks]);
};
exports.useFormattedSideNavItems = useFormattedSideNavItems;