"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SecuritySideNavComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxChromeNavigation = require("@kbn/shared-ux-chrome-navigation");
var _panel = require("@kbn/security-solution-side-nav/panel");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _services = require("../../common/services");
var _use_side_nav_items = require("../side_navigation/use_side_nav_items");
var _categories = require("../categories");
var _navigation_tree = require("../navigation_tree/navigation_tree");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPanelContentProvider = projectNavLinks => /*#__PURE__*/_react.default.memo(function PanelContentProvider({
  selectedNode: {
    id: linkId
  },
  closePanel
}) {
  const currentPanelItem = projectNavLinks.find(item => item.id === linkId);
  const {
    title = '',
    links = [],
    categories
  } = currentPanelItem !== null && currentPanelItem !== void 0 ? currentPanelItem : {};
  const items = (0, _use_side_nav_items.useFormattedSideNavItems)(links);
  if (items.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_panel.SolutionSideNavPanelContent, {
    title: title,
    items: items,
    categories: categories,
    onClose: closePanel
  });
});
const usePanelContentProvider = projectNavLinks => {
  return (0, _react.useCallback)(() => ({
    content: getPanelContentProvider(projectNavLinks)
  }), [projectNavLinks]);
};
const SecuritySideNavComponent = /*#__PURE__*/_react.default.memo(function SecuritySideNavComponent() {
  const services = (0, _services.useKibana)().services;
  const projectNavLinks = (0, _useObservable.default)(services.getProjectNavLinks$(), []);
  const navigationTree = (0, _react.useMemo)(() => (0, _navigation_tree.formatNavigationTree)(projectNavLinks, _categories.CATEGORIES, _categories.FOOTER_CATEGORIES), [projectNavLinks]);
  const panelContentProvider = usePanelContentProvider(projectNavLinks);
  return /*#__PURE__*/_react.default.createElement(_sharedUxChromeNavigation.NavigationKibanaProvider, {
    core: services,
    serverless: services.serverless,
    cloud: services.cloud
  }, /*#__PURE__*/_react.default.createElement(_sharedUxChromeNavigation.DefaultNavigation, {
    dataTestSubj: "securitySolutionSideNav",
    navigationTree: navigationTree,
    panelContentProvider: panelContentProvider
  }));
});

// eslint-disable-next-line import/no-default-export
exports.SecuritySideNavComponent = SecuritySideNavComponent;
var _default = SecuritySideNavComponent;
exports.default = _default;