"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBreadcrumbHidden = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _constants = require("../links/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// We need to hide breadcrumbs for some pages (tabs) because they appear duplicated.
// These breadcrumbs are incorrectly processed as trailing breadcrumbs in SecuritySolution, because of `SpyRoute` architecture limitations.
// They are navLinks tree with a SecurityPageName, so they should be treated as leading breadcrumbs in ESS as well.
// TODO: Improve the breadcrumbs logic in `use_breadcrumbs_nav` to avoid this workaround.
const HIDDEN_BREADCRUMBS = new Set([_securitySolutionNavigation.SecurityPageName.networkDns, _securitySolutionNavigation.SecurityPageName.networkHttp, _securitySolutionNavigation.SecurityPageName.networkTls, _securitySolutionNavigation.SecurityPageName.networkAnomalies, _securitySolutionNavigation.SecurityPageName.networkEvents, _securitySolutionNavigation.SecurityPageName.usersAuthentications, _securitySolutionNavigation.SecurityPageName.usersAnomalies, _securitySolutionNavigation.SecurityPageName.usersRisk, _securitySolutionNavigation.SecurityPageName.usersEvents, _securitySolutionNavigation.SecurityPageName.uncommonProcesses, _securitySolutionNavigation.SecurityPageName.hostsAnomalies, _securitySolutionNavigation.SecurityPageName.hostsEvents, _securitySolutionNavigation.SecurityPageName.hostsRisk, _securitySolutionNavigation.SecurityPageName.sessions]);
const isBreadcrumbHidden = id => HIDDEN_BREADCRUMBS.has(id) || /* management sub-pages set their breadcrumbs themselves, the main Management breadcrumb is configured with our navigationTree definition */
id.startsWith(_constants.ExternalPageName.management) && id !== _constants.ExternalPageName.management;
exports.isBreadcrumbHidden = isBreadcrumbHidden;