"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableManagementCardsLanding = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _constants = require("./links/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SecurityManagementCards = new Map([[_constants.ExternalPageName.visualize, 'content'], [_constants.ExternalPageName.maps, 'content'], [_securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement, 'alerts']]);
const enableManagementCardsLanding = services => {
  const {
    management,
    application
  } = services;
  services.getProjectNavLinks$().subscribe(projectNavLinks => {
    const extendCardNavDefinitions = projectNavLinks.reduce((acc, projectNavLink) => {
      if (SecurityManagementCards.has(projectNavLink.id)) {
        var _SecurityManagementCa, _projectNavLink$descr, _projectNavLink$landi;
        const {
          appId,
          deepLinkId,
          path
        } = (0, _securitySolutionNavigation.getNavigationPropsFromId)(projectNavLink.id);
        acc[projectNavLink.id] = {
          category: (_SecurityManagementCa = SecurityManagementCards.get(projectNavLink.id)) !== null && _SecurityManagementCa !== void 0 ? _SecurityManagementCa : 'other',
          title: projectNavLink.title,
          description: (_projectNavLink$descr = projectNavLink.description) !== null && _projectNavLink$descr !== void 0 ? _projectNavLink$descr : '',
          icon: (_projectNavLink$landi = projectNavLink.landingIcon) !== null && _projectNavLink$landi !== void 0 ? _projectNavLink$landi : '',
          href: application.getUrlForApp(appId, {
            deepLinkId,
            path
          }),
          skipValidation: true
        };
      }
      return acc;
    }, {});
    management.setupCardsNavigation({
      enabled: true,
      extendCardNavDefinitions
    });
  });
};
exports.enableManagementCardsLanding = enableManagementCardsLanding;