"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mlNavLinks = exports.mlNavCategories = exports.mlAppLink = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _common = require("@kbn/security-solution-plugin/common");
var _constants = require("../constants");
var i18n = _interopRequireWildcard(require("./ml_translations"));
var _lazy_icons = require("../../../common/lazy_icons");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// appLinks configures the Security Solution pages links
const mlAppLink = {
  id: _securitySolutionNavigation.SecurityPageName.mlLanding,
  title: i18n.ML_TITLE,
  path: _constants.SecurityPagePath[_securitySolutionNavigation.SecurityPageName.mlLanding],
  capabilities: [`${_common.SERVER_APP_ID}.show`],
  globalSearchKeywords: [i18n.ML_KEYWORD],
  hideTimeline: true,
  skipUrlState: true,
  links: [] // no security internal links
};
exports.mlAppLink = mlAppLink;
const mlNavCategories = [{
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_constants.ExternalPageName.mlOverview, _constants.ExternalPageName.mlNotifications, _constants.ExternalPageName.mlMemoryUsage]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.title,
  label: i18n.ANOMALY_DETECTION_CATEGORY,
  linkIds: [_constants.ExternalPageName.mlAnomalyDetection, _constants.ExternalPageName.mlAnomalyExplorer, _constants.ExternalPageName.mlSingleMetricViewer, _constants.ExternalPageName.mlSettings]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.title,
  label: i18n.DATA_FRAME_ANALYTICS_CATEGORY,
  linkIds: [_constants.ExternalPageName.mlDataFrameAnalytics, _constants.ExternalPageName.mlResultExplorer, _constants.ExternalPageName.mlAnalyticsMap]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.title,
  label: i18n.MODEL_MANAGEMENT_CATEGORY,
  linkIds: [_constants.ExternalPageName.mlNodesOverview]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.title,
  label: i18n.DATA_VISUALIZER_CATEGORY,
  linkIds: [_constants.ExternalPageName.mlFileUpload, _constants.ExternalPageName.mlIndexDataVisualizer, _constants.ExternalPageName.mlDataDrift]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.title,
  label: i18n.AIOPS_LABS_CATEGORY,
  linkIds: [_constants.ExternalPageName.mlExplainLogRateSpikes, _constants.ExternalPageName.mlLogPatternAnalysis, _constants.ExternalPageName.mlChangePointDetections]
}];

// navLinks define the navigation links for the Security Solution pages and External pages as well
exports.mlNavCategories = mlNavCategories;
const mlNavLinks = [{
  id: _constants.ExternalPageName.mlOverview,
  title: i18n.OVERVIEW_TITLE,
  landingIcon: _lazy_icons.IconLensLazy,
  description: i18n.OVERVIEW_DESC
}, {
  id: _constants.ExternalPageName.mlNotifications,
  title: i18n.NOTIFICATIONS_TITLE,
  landingIcon: _lazy_icons.IconMarketingLazy,
  description: i18n.NOTIFICATIONS_DESC
}, {
  id: _constants.ExternalPageName.mlMemoryUsage,
  title: i18n.MEMORY_USAGE_TITLE,
  landingIcon: _lazy_icons.IconInfraLazy,
  description: i18n.MEMORY_USAGE_DESC
}, {
  id: _constants.ExternalPageName.mlAnomalyDetection,
  title: i18n.ANOMALY_DETECTION_TITLE,
  landingIcon: _lazy_icons.IconJobsLazy,
  description: i18n.ANOMALY_DETECTION_DESC
}, {
  id: _constants.ExternalPageName.mlAnomalyExplorer,
  title: i18n.ANOMALY_EXPLORER_TITLE,
  landingIcon: _lazy_icons.IconKeywordLazy,
  description: i18n.ANOMALY_EXPLORER_DESC
}, {
  id: _constants.ExternalPageName.mlSingleMetricViewer,
  title: i18n.SINGLE_METRIC_VIEWER_TITLE,
  landingIcon: _lazy_icons.IconVisualizationLazy,
  description: i18n.SINGLE_METRIC_VIEWER_DESC
}, {
  id: _constants.ExternalPageName.mlSettings,
  title: i18n.SETTINGS_TITLE,
  landingIcon: _lazy_icons.IconSettingsLazy,
  description: i18n.SETTINGS_DESC
}, {
  id: _constants.ExternalPageName.mlDataFrameAnalytics,
  title: i18n.DATA_FRAME_ANALYTICS_TITLE,
  landingIcon: _lazy_icons.IconJobsLazy,
  description: i18n.DATA_FRAME_ANALYTICS_DESC
}, {
  id: _constants.ExternalPageName.mlResultExplorer,
  title: i18n.RESULT_EXPLORER_TITLE,
  landingIcon: _lazy_icons.IconDashboardLazy,
  description: i18n.RESULT_EXPLORER_DESC
}, {
  id: _constants.ExternalPageName.mlAnalyticsMap,
  title: i18n.ANALYTICS_MAP_TITLE,
  landingIcon: _lazy_icons.IconChartArrowLazy,
  description: i18n.ANALYTICS_MAP_DESC
}, {
  id: _constants.ExternalPageName.mlNodesOverview,
  title: i18n.NODES_OVERVIEW_TITLE,
  landingIcon: _lazy_icons.IconManagerLazy,
  description: i18n.NODES_OVERVIEW_DESC
}, {
  id: _constants.ExternalPageName.mlFileUpload,
  title: i18n.FILE_UPLOAD_TITLE,
  landingIcon: _lazy_icons.IconFilebeatLazy,
  description: i18n.FILE_UPLOAD_DESC
}, {
  id: _constants.ExternalPageName.mlIndexDataVisualizer,
  title: i18n.INDEX_DATA_VISUALIZER_TITLE,
  landingIcon: _lazy_icons.IconDataViewLazy,
  description: i18n.INDEX_DATA_VISUALIZER_DESC
}, {
  id: _constants.ExternalPageName.mlDataDrift,
  title: i18n.DATA_DRIFT_TITLE,
  landingIcon: _lazy_icons.IconRapidBarGraphLazy,
  description: i18n.DATA_DRIFT_TITLE
}, {
  id: _constants.ExternalPageName.mlExplainLogRateSpikes,
  title: i18n.LOG_RATE_ANALYSIS_TITLE,
  landingIcon: _lazy_icons.IconFilebeatChartLazy,
  description: i18n.LOG_RATE_ANALYSIS_DESC
}, {
  id: _constants.ExternalPageName.mlLogPatternAnalysis,
  title: i18n.LOG_PATTERN_ANALYSIS_TITLE,
  landingIcon: _lazy_icons.IconReplicationLazy,
  description: i18n.LOG_PATTERN_ANALYSIS_DESC
}, {
  id: _constants.ExternalPageName.mlChangePointDetections,
  title: i18n.CHANGE_POINT_DETECTIONS_TITLE,
  landingIcon: _lazy_icons.IconIntuitiveLazy,
  description: i18n.CHANGE_POINT_DETECTIONS_DESC
}];
exports.mlNavLinks = mlNavLinks;