"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.projectAppLinksSwitcher = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _lodash = require("lodash");
var _investigations_links = require("./sections/investigations_links");
var _ml_links = require("./sections/ml_links");
var _assets_links = require("./sections/assets_links");
var _project_settings_links = require("./sections/project_settings_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This function is called by the security_solution plugin to alter the app links
// that will be registered to the Security Solution application on Serverless projects.
// The capabilities filtering is done after this function is called by the security_solution plugin.
const projectAppLinksSwitcher = appLinks => {
  const projectAppLinks = (0, _lodash.cloneDeep)(appLinks);

  // Remove timeline link
  const [timelineLinkItem] = (0, _lodash.remove)(projectAppLinks, {
    id: _securitySolutionNavigation.SecurityPageName.timelines
  });
  if (timelineLinkItem) {
    // Add investigations link
    projectAppLinks.push((0, _investigations_links.createInvestigationsLinkFromTimeline)(timelineLinkItem));
  }

  // Remove data quality dashboard link
  const dashboardLinkItem = (0, _lodash.find)(projectAppLinks, {
    id: _securitySolutionNavigation.SecurityPageName.dashboards
  });
  if (dashboardLinkItem && dashboardLinkItem.links) {
    (0, _lodash.remove)(dashboardLinkItem.links, {
      id: _securitySolutionNavigation.SecurityPageName.dataQuality
    });
  }

  // Remove manage link
  const [manageLinkItem] = (0, _lodash.remove)(projectAppLinks, {
    id: _securitySolutionNavigation.SecurityPageName.administration
  });
  if (manageLinkItem) {
    // Add assets link
    projectAppLinks.push((0, _assets_links.createAssetsLinkFromManage)(manageLinkItem));
    // Add entity analytics link if exists
    projectAppLinks.push(...(0, _project_settings_links.createProjectSettingsLinksFromManage)(manageLinkItem));
  }

  // Add ML link
  projectAppLinks.push(_ml_links.mlAppLink);
  return projectAppLinks;
};
exports.projectAppLinksSwitcher = projectAppLinksSwitcher;