"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageProjectsButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _util = require("../../navigation/links/util");
var _translations = require("./translations");
var _services = require("../../common/services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManageProjectsButtonComponent = () => {
  const {
    cloud
  } = (0, _services.useKibana)().services;
  const href = (0, _util.getCloudUrl)('projects', cloud);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": _translations.MANAGE_PROJECTS,
    className: "step-paragraph",
    fill: true,
    href: href,
    target: "_blank"
  }, _translations.MANAGE_PROJECTS, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout"
  }));
};
const ManageProjectsButton = /*#__PURE__*/_react.default.memo(ManageProjectsButtonComponent);
exports.ManageProjectsButton = ManageProjectsButton;