"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLI_APP_FEATURES = void 0;
var _keys = require("@kbn/security-solution-features/keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLI_APP_FEATURES = {
  security: {
    essentials: [_keys.AppFeatureKey.endpointHostManagement, _keys.AppFeatureKey.endpointPolicyManagement],
    complete: [_keys.AppFeatureKey.advancedInsights, _keys.AppFeatureKey.assistant, _keys.AppFeatureKey.investigationGuide, _keys.AppFeatureKey.threatIntelligence, _keys.AppFeatureKey.casesConnectors, _keys.AppFeatureKey.externalRuleActions]
  },
  endpoint: {
    essentials: [_keys.AppFeatureKey.endpointPolicyProtections, _keys.AppFeatureKey.endpointArtifactManagement, _keys.AppFeatureKey.endpointExceptions],
    complete: [_keys.AppFeatureKey.endpointResponseActions, _keys.AppFeatureKey.osqueryAutomatedResponseActions, _keys.AppFeatureKey.endpointExceptions]
  },
  cloud: {
    essentials: [],
    complete: []
  }
};
exports.PLI_APP_FEATURES = PLI_APP_FEATURES;